ORCA/M Asm65816 2.1.0

0001 0134                       title 'Window Mgr Patch   GS ROM 3 Patch' 
0002 0134              *******************************************************************
0003 0134              *
0004 0134              *                   Window manager patches for ROM 3
0005 0134              *
0006 0134              * System Disk 5.0
0007 0134              *
0008 0134              * 11 May 89         Mensch
0009 0134              *
0010 0134              * File first created.  Added call table and patch for GetWRefCon.
0011 0134              *
0012 0134              * 21 May 89         Steven Glass
0013 0134              *
0014 0134              * Added patch to TaskMaster and TaskMasterDA to fix bug
0015 0134              * in window DefProc.
0016 0134              *
0017 0134              * 22 May 89         Steven Glass
0018 0134              *
0019 0134              * Made TaskMaster patch work better.
0020 0134              *
0021 0134              * 25 May 89         Steven Glass
0022 0134              *
0023 0134              * Removed TaskMaster patch and put it in QD where it belongs.
0024 0134              * This makes it possible for tools like scrambler and callcheck
0025 0134              * to keep running.
0026 0134              *
0027 0134              * 31 May 89         Harry Yee
0028 0134              *
0029 0134              * Take prototype bit out of version number. Final version = 3.1
0030 0134              * for System Disk 5.0.
0031 0134              *
0032 0134              * 01 Jun 89         Harry Yee
0033 0134              *
0034 0134              * Fix WindStartUp. There are times when trying to grow the handle
0035 0134              * that it could fail.  Now we get a new handle before calling the
0036 0134              * real WindStartUp and then copy the old Data handle into the new,
0037 0134              * dispose of the old data handle and then dereference this new
0038 0134              * handle updating the Data ptr in the window mgr.
0039 0134              *
0040 0134              * Made sure to update any pointers in the data segment that
0041 0134              * pointed into the data segment.
0042 0134              *
0043 0134              * 19 Sep 89         Harry Yee
0044 0134              *
0045 0134              * Patch for TaskMaster which defines another task bit so that
0046 0134              * TaskMaster will not call GetNextEvent uses some equates that
0047 0134              * have not been defined. These are the equates used to access
0048 0134              * values on the stack frame for NewTaskMaster.
0049 0134              *
0050 0134              * 22-Sep-90         Dave Lyons
0051 0134              *
0052 0134              * Rolled version to $8303.
0053 0134              * Fixed ErrorWindow to return CLC on no error.
0054 0134              *
0055 0134              * 24-Sep-90         Dave Lyons
0056 0134              *
0057 0134              * Fixed WindStatus to return SEC/A=0 if it's started up but
0058 0134              * there's one or more BeginUpdate pending.  (Changed WindStatus,
0059 0134              * BeginUpdate, EndUpdate.)
0060 0134              *
0061 0134              * 17-Nov-90         Dave Lyons
0062 0134              *
0063 0134              * Put back all.macros.
0064 0134              * Sucked in new AlertWindow from TOOL014 source.
0065 0134              *
0066 0134              * 14-Feb-91         Dave Lyons
0067 0134              *
0068 0134              * Suck in GetAuxWindInfo, DoModalWindow, MWGetCtlPart, MWSetMenuProc,
0069 0134              * MWStdDrawProc, MWSetUpEditMenu, FindCursorCtl.
0070 0134              *
0071 0134              * 7?-Mar-91         Dave Lyons
0072 0134              *
0073 0134              * Added patch entry for ResizeInfoBar.
0074 0134              *
0075 0134              * 9-Mar-91          Dave Lyons
0076 0134              *
0077 0134              * Patch ErrorWindow to call SysBeep2.
0078 0134              *
0079 0134              * 25-Mar-91         Dave Lyons
0080 0134              *
0081 0134              * Brought ErrorWindow SysBeep2 logic up to date with Tool014 (calls
0082 0134              * SysBeep2($CEFF) for errors outside the 00..FF range).
0083 0134              *
0084 0134              * Patched FindWindow to return window-pointer = nil if the result
0085 0134              * is wInMenu.
0086 0134              *
0087 0134              * 12-Apr-91         Dave Lyons
0088 0134              *
0089 0134              * Sucked in HandleDiskInsert from WindMgr:NewCalls.asm.  Changed
0090 0134              * WindStartUp to call HandleDiskInsert(1,0) to initialize it.
0091 0134              *
0092 0134              * 18-Apr-91         Dave Lyons
0093 0134              *
0094 0134              * WindStartUp passes flags of $2000 to HandleDiskInsert instead
0095 0134              * of $0001 (devices initialized to current status instead of
0096 0134              * offline status).
0097 0134              *
0098 0134              * 15-May-91         Dave Lyons
0099 0134              *
0100 0134              * Fix GetSysWFlag/GetWKind(NIL) to always return False.
0101 0134              *
0102 0134              * 20-May-91         Dave Lyons
0103 0134              *
0104 0134              * Made WindStartUp try to load and start QDAux if it isn't
0105 0134              * already started, so that AlertWindow can use DrawIcon.
0106 0134              *
0107 0134              * 21-May-91         Dave Lyons
0108 0134              *
0109 0134              * Patched NewWindow2 for color table resource problem--now it
0110 0134              * changes handle- and resource-based color table references
0111 0134              * into locked+fixed pointers with bit 30 set.  CloseWindow and
0112 0134              * SetFrameColor dispose of the 10-byte color table handle if
0113 0134              * a standard window's color table pointer's bit 30 is set.
0114 0134              *
0115 0134              * 16-Sep-91         Dave Lyons
0116 0134              *
0117 0134              * Made WindStartUp prelocate the 320 and 640 disk-swap icons
0118 0134              * so AlertWindow can avoid a reentrant call to LoadResource.
0119 0134              *
0120 0134              * 12-Dec-91         Dave Lyons
0121 0134              *
0122 0134              * Post-patch Desktop(8) to call SendRequest systemSaysNewDeskMsg
0123 0134              * (8), and to free the WM's copy of the old desk message when
0124 0134              * it is no longer current.
0125 0134              *
0126 0134              * 5-Feb-92          Dave Lyons
0127 0134              *
0128 0134              * Version $0303 for 6.0 final.
0129 0134              *
0130 0134              ******************************************************************
0131 0134              *
0132 0134              * 17-Feb-92         Dave Lyons
0133 0134              *
0134 0134              * Version $8304 for 6.0.1d1.
0135 0134              *
0136 0134              * Make WindStartUp do a BlockMove of a valid number of bytes
0137 0134              * from the old data handle to the new handle (it was moving
0138 0134              * garbage, which Big Brother traps on).  Moves $01F2 instead
0139 0134              * of $02D1.
0140 0134              *
0141 0134              * 6-Mar-92          Dave Lyons
0142 0134              *
0143 0134              * Add UpdateWindow call.
0144 0134              *
0145 0134              * 1-Dec-92          Dave Lyons
0146 0134              *
0147 0134              * Changed TaskMaster patch to make tmNoGetNextEvent work.  It
0148 0134              * jumped back into ROM too early and treated the bit as reserved.
0149 0134              * In 5.0.3, 5.0.4, and 6.0 this bit works on ROM 1 only.
0150 0134              *
0151 0134              * 2-Apr-93 DAL
0152 0134              *
0153 0134              * Version $0304 for 6.0.1.
0154 0134              *
0155 0134              ******************************************************************
0156 0134
0157 0134              ****************************************************************
0158 0134              *                                                              *
0159 0134              *              Copyright (C) 1989-1992                         *
0160 0134              *              All Rights Reserved                             *
0161 0134              *              Apple Computer, Inc.                            *
0162 0134              *                                                              *
0163 0134              ****************************************************************
0164 0134
0165 0134                       Blanks off 
0166 0134                       String asis 
0167 0134
0168 0134                       include 'all.macros' 
0169 0134                       include ':::windMgr:WindMgrEquates.asm' 
0170 0134
0171 0134              WindVersionNum equ   $0304              ;2-Apr-93 DAL
0172 0134
0173 0134              ToStrip  equ   $E10184                  ; Jmp vector to 0ErrOut routine
0174 0134              SkipNormalStuffROM equ   $FD26BE        ; for the taskmaster patch
0175 0134
0176 0134
0177 0134              ;----------------------------------------------------------------
0178 0134              ; Routines needed by the patch file from the main window manager
0179 0134              ; code
0180 0134                       Import GetwRefCon 
0181 0134                       import AlertWindow 
0182 0134
0183 0134                       entry WindowUpdateCount 
0184 0134                       Entry NewTaskMaster 
0185 0134                       Entry GetFrameColor 
0186 0134                       Entry NewStartup 
0187 0134                       ENTRY WindVersion 
0188 0134                       Entry ErrorWindow              ;22-Sep-90 DAL
0189 0134                       Entry BeginUpdate              ;24-Sep-90 DAL
0190 0134                       Entry EndUpdate                ;24-Sep-90 DAL
0191 0134                       Entry WindStatus               ;25-sep-90 DAL
0192 0134                       entry GrowWindow               ;26-Nov-90 DAL
0193 0134                       entry CloseWindow              ;28-Feb-91 DAL
0194 0134                       import GetAuxWindInfo          ;14-Feb-91 DAL
0195 0134                       import DoModalWindow           ;14-Feb-91 DAL
0196 0134                       import MWGetCtlPart            ;14-Feb-91 DAL
0197 0134                       import MWSetMenuProc           ;14-Feb-91 DAL
0198 0134                       import MWStdDrawProc           ;14-Feb-91 DAL
0199 0134                       import MWSetUpEditMenu         ;14-Feb-91 DAL
0200 0134                       import FindCursorCtl           ;14-Feb-91 DAL
0201 0134                       import ResizeInfoBar           ; 5-Mar-91 DAL
0202 0134                       entry FindWindow               ;25-Mar-91 DAL
0203 0134                       import HandleDiskInsert        ;12-Apr-91 DAL
0204 0134                       entry GetWKind2                ;15-May-91 DAL
0205 0134                       entry NewWindow2               ;21-May-91 DAL
0206 0134                       entry SetFrameColor            ;21-May-91 DAL
0207 0134                       entry Desktop                  ;12-Dec-91 DAL
0208 0134                       import UpdateWindow            ;6-Mar-92 DAL
0209 0134
0210 0134              WMCallTable PROC EXPORT 
0211 0134                       EXPORT FPT 
0212 0134 6D 00        FPT      DC W:(ENDFPT-FPT)/4
0213 0136 00 00                 DC W:0
0214 0138 00 00 00 00           DC L:0                         ; WindBootInit $010E
0215 013C B6 0A 02 00           DC L:NewStartup-1              ; WindStartup $020E
0216 0140 00 00 00 00           DC L:0                         ; WindShutDown $030E
0217 0144 E7 05 02 00           DC L:WindVersion-1             ; $040E
0218 0148 00 00 00 00           DC L:0                         ; WindReset $050E
0219 014C 85 0D 02 00           DC L:WindStatus-1              ; $060E
0220 0150 00 00 00 00           DC L:0                         ; Reserved $070E
0221 0154 00 00 00 00           DC L:0                         ; Reserved $080E
0222 0158 00 00 00 00           DC L:0                         ; NewWindow $090E
0223 015C 00 00 00 00           DC L:0                         ; CheckUpdate $0A0E
0224 0160 61 09 02 00           DC L:CloseWindow-1             ; $0B0E (patched 28-Feb-91 DAL)
0225 0164 82 09 02 00           DC L:Desktop-1                 ; $0C0E (patched 12-Dec-91 DAL)
0226 0168 00 00 00 00           DC L:0                         ; SetWTitle $0D0E
0227 016C 00 00 00 00           DC L:0                         ; GetWTitle $0E0E
0228 0170 2F 0A 02 00           DC L:SetFrameColor-1           ; SetFrameColor $0F0E patched 21-May-91 DAL
0229 0174 F7 0B 02 00           DC L:GetFrameColor-1           ; GetFrameColor $100E
0230 0178 00 00 00 00           DC L:0                         ; SelectWindow $110E
0231 017C 00 00 00 00           DC L:0                         ; HideWindow $120E
0232 0180 00 00 00 00           DC L:0                         ; ShowWindow $130E
0233 0184 00 00 00 00           DC L:0                         ; SendBehind $140E
0234 0188 00 00 00 00           DC L:0                         ; FrontWindow $150E
0235 018C 00 00 00 00           DC L:0                         ; SetInfoDraw $160E
0236 0190 2B 0C 02 00           DC L:FindWindow-1              ; $170E (patched 25-Mar-91 DAL)
0237 0194 00 00 00 00           DC L:0                         ; TrackGoAway $180E
0238 0198 00 00 00 00           DC L:0                         ; MoveWindow $190E
0239 019C 00 00 00 00           DC L:0                         ; DragWindow $1A0E
0240 01A0 3C 0C 02 00           DC L:GrowWindow-1              ;            $1B0E
0241 01A4 00 00 00 00           DC L:0                         ; SizeWindow $1C0E
0242 01A8 FF 0C 02 00           DC L:NewTaskMaster-1           ; $1D0E
0243 01AC 92 0D 02 00           DC L:BeginUpdate-1             ; $1E0E
0244 01B0 A1 0D 02 00           DC L:EndUpdate-1               ; $1F0E
0245 01B4 00 00 00 00           DC L:0                         ; GetWMgrPort $200E
0246 01B8 00 00 00 00           DC L:0                         ; PinRect $210E
0247 01BC 00 00 00 00           DC L:0                         ; HiliteWindow $220E
0248 01C0 00 00 00 00           DC L:0                         ; ShowHide $230E
0249 01C4 00 00 00 00           DC L:0                         ; BringToFront $240E
0250 01C8 00 00 00 00           DC L:0                         ; WNewRes $250E
0251 01CC 00 00 00 00           DC L:0                         ; TrackZoom $260E
0252 01D0 00 00 00 00           DC L:0                         ; ZoomWindow $270E
0253 01D4 00 00 00 00           DC L:0                         ; SetWRefCon $280E
0254 01D8 C7 0D 02 00           DC L:GetWRefCon-1              ; GetWRefCon $290E
0255 01DC 00 00 00 00           DC L:0                         ; GetNextWindow $2A0E
0256 01E0 B0 0D 02 00           DC L:GetWKind2-1               ; GetWKind $2B0E patched 15-May-91 DAL
0257 01E4 00 00 00 00           DC L:0                         ; GetWFrame $2C0E
0258 01E8 00 00 00 00           DC L:0                         ; SetWFrame $2D0E
0259 01EC 00 00 00 00           DC L:0                         ; GetStructRgn $2E0E
0260 01F0 00 00 00 00           DC L:0                         ; GetContRgn $2F0E
0261 01F4 00 00 00 00           DC L:0                         ; GetUpdateRgn $300E
0262 01F8 00 00 00 00           DC L:0                         ; GetDefProc $310E
0263 01FC 00 00 00 00           DC L:0                         ; SetDefProc $320E
0264 0200 00 00 00 00           DC L:0                         ; GetWControls $330E
0265 0204 00 00 00 00           DC L:0                         ; SetOrgnMask $340E
0266 0208 00 00 00 00           DC L:0                         ; GetInfoRefCon $350E
0267 020C 00 00 00 00           DC L:0                         ; SetInfoRefCon $360E
0268 0210 00 00 00 00           DC L:0                         ; GetZoomRect $370E
0269 0214 00 00 00 00           DC L:0                         ; SetZoomRect $380E
0270 0218 00 00 00 00           DC L:0                         ; Refresh $390E
0271 021C 00 00 00 00           DC L:0                         ; InvalRect $3A0E
0272 0220 00 00 00 00           DC L:0                         ; InvalRgn $3B0E
0273 0224 00 00 00 00           DC L:0                         ; ValidRect $3C0E
0274 0228 00 00 00 00           DC L:0                         ; ValidRgn $3D0E
0275 022C 00 00 00 00           DC L:0                         ; GetCOrigin $3E0E
0276 0230 00 00 00 00           DC L:0                         ; SetCOrigin $3F0E
0277 0234 00 00 00 00           DC L:0                         ; GetDataSize $400E
0278 0238 00 00 00 00           DC L:0                         ; SetDataSize $410E
0279 023C 00 00 00 00           DC L:0                         ; GetMaxGrow $420E
0280 0240 00 00 00 00           DC L:0                         ; SetMaxGrow $430E
0281 0244 00 00 00 00           DC L:0                         ; GetScroll $440E
0282 0248 00 00 00 00           DC L:0                         ; SetScroll $450E
0283 024C 00 00 00 00           DC L:0                         ; GetPage $460E
0284 0250 00 00 00 00           DC L:0                         ; SetPage $470E
0285 0254 00 00 00 00           DC L:0                         ; GetCDraw $480E
0286 0258 00 00 00 00           DC L:0                         ; SetCDraw $490E
0287 025C 00 00 00 00           DC L:0                         ; GetInfoDraw $4A0E
0288 0260 00 00 00 00           DC L:0                         ; SetSysWindow $4B0E
0289 0264 B0 0D 02 00           DC L:GetWKind2-1               ; GetSysWFlag $4C0E patched 15-May-91 DAL
0290 0268 00 00 00 00           DC L:0                         ; StartDrawing $4D0E
0291 026C 00 00 00 00           DC L:0                         ; SetWMgrIcons $4E0E
0292 0270 00 00 00 00           DC L:0                         ; GetRectInfo $4F0E
0293 0274 00 00 00 00           DC L:0                         ; StartInfoDraw $500E
0294 0278 00 00 00 00           DC L:0                         ; EndInfoDrawing $510E
0295 027C 00 00 00 00           DC L:0                         ; GetFirstWindow $520E added to version $8104
0296 0280 00 00 00 00           DC L:0                         ; WindDragRect $530E
0297 0284 00 00 00 00           DC L:0                         ; GetDragRect $540E not public.
0298 0288 00 00 00 00           DC L:0                         ; DrawInfoBar $550E
0299 028C 00 00 00 00           DC L:0                         ; WindowGlobal $560E added 02/19/87
0300 0290 00 00 00 00           DC L:0                         ; SetCOrigin2 $570E added 04/07/87
0301 0294 00 00 00 00           DC L:0                         ; GetWindowMgrGlobals $580E added 03/08/88
0302 0298 F2 0D 02 00           DC L:AlertWindow-1
0303 029C 00 00 00 00           DC L:0                         ; StartFrameDrawing $5A0E added 03/15/88
0304 02A0 00 00 00 00           DC L:0                         ; EndFrameDrawing $5B0E added 03/15/88
0305 02A4 00 00 00 00           DC L:0                         ; ResizeWindow $5C0E added 03/15/88
0306 02A8
0307 02A8 00 00 00 00           DC L:0                         ; TaskMasterContent $5D0E  added 22 Sep 88  SEG
0308 02AC 00 00 00 00           DC L:0                         ; TaskMasterKey $5E0E  added 28 Sep 88  SEG
0309 02B0 00 00 00 00           DC L:0                         ; TaskMasterDA-1	; $5F0E  added 02 Oct 88  SEG
0310 02B4 00 00 00 00           DC L:0                         ; CompileString $600E added 10/20/88 Dan O.
0311 02B8 F1 05 02 00           DC L:NewWindow2-1              ; NewWindow2 $610E patched 21-May-91 DAL
0312 02BC 2B 09 02 00           DC L:ErrorWindow-1             ; ErrorWindow patch 22-Sep-90 DAL
0313 02C0              *** 6.0
0314 02C0 AB 19 02 00           DC L:GetAuxWindInfo-1          ;$630E added 14-Feb-91 DAL
0315 02C4 73 1B 02 00           DC L:DoModalWindow-1           ;$640E added 14-Feb-91 DAL
0316 02C8 33 23 02 00           DC L:MWGetCtlPart-1            ;$650E added 14-Feb-91 DAL
0317 02CC 40 23 02 00           DC L:MWSetMenuProc-1           ;$660E added 14-Feb-91 DAL
0318 02D0 6A 23 02 00           DC L:MWStdDrawProc-1           ;$670E added 14-Feb-91 DAL
0319 02D4 E8 23 02 00           DC L:MWSetUpEditMenu-1         ;$680E added 14-Feb-91 DAL
0320 02D8 10 25 02 00           DC L:FindCursorCtl-1           ;$690E added 14-Feb-91 DAL
0321 02DC 99 25 02 00           DC L:ResizeInfoBar-1           ;$6A0E added  5-Mar-91 DAL
0322 02E0 FC 25 02 00           DC L:HandleDiskInsert-1        ;$6B0E added 12-Apr-91 DAL
0323 02E4              *** 6.1
0324 02E4 5C 2F 02 00           DC L:UpdateWindow-1            ;$6C0E added 6-Mar-92 DAL
0325 02E8
0326 02E8                       EXPORT ENDFPT 
0327 02E8              ENDFPT    
0328 02E8                       ENDP 
0329 02E8
0330 02E8
0331 02E8              ********************************************************
0332 02E8              *
0333 02E8              * WindVersion patch
0334 02E8              *
0335 02E8              ********************************************************
0336 02E8
0337 02E8              WindVersion PROC 
0338 02E8
0339 02E8 A9 04 03              lda   #WindVersionNum
0340 02EB 83 07                 sta   7,s
0341 02ED A9 00 00              lda   #0
0342 02F0 18                    clc   
0343 02F1 6B                    rtl   
0344 02F2
0345 02F2                       ENDP 
0346 02F2
0347 02F2              ********************************************************
0348 02F2              *
0349 02F2              * NewWindow2 patch for ROM 3 -- 21-May-91 DAL
0350 02F2              *
0351 02F2              * The ROM can't handle window color table handles, so
0352 02F2              * if the color table is referenced by handle or resource
0353 02F2              * we need to make a copy of the template and do an
0354 02F2              * equivalent NewWindow2 call with a by-pointer copy of
0355 02F2              * the color table.
0356 02F2              *
0357 02F2              ********************************************************
0358 02F2              ;==================================================================
0359 02F2              ;                   Create window from new template.
0360 02F2              ;                   it can be fetched from a resource or be passed
0361 02F2              ;                   by pointer or handle.
0362 02F2              ;
0363 02F2              ; Modified 12-dec-88 Mensch
0364 02F2              ;    Added support for input verbs so that NewWindow2 can use ptrs
0365 02F2              ;      and handles. Added Input verb to passed parms and template
0366 02F2              ;==================================================================
0367 02F2              ;
0368 02F2              ;   IN:  PUSH:LONG - space for result.
0369 02F2              ;        PUSH:LONG - window title.
0370 02F2              ;        PUSH:LONG - refCon.
0371 02F2              ;        PUSH:LONG - address of content draw routine, NIL if none.
0372 02F2              ;        PUSH:LONG - address of window defProc, NIL for standard.
0373 02F2              ;        PUSH:WORD - input verb defines what next long word is.
0374 02F2              ;        PUSH:LONG - ID of resource that is window parameter table template.
0375 02F2              ;        PUSH:WORD - type of resource that is window parameter table template.
0376 02F2              ;
0377 02F2              ;  OUT:  LONG - pointer to window graphPort, NIL if window not created.
0378 02F2              ;
0379 02F2              NewWindow2 PROC EXPORT 
0380 02F2              ;
0381 02F2              ; --- New window parameter list offsets.
0382 02F2              ;
0383 02F2              p_length equ   0                        Number of bytes in parameter list.
0384 02F2              p_wframe equ   p_length+2               Type of window, frame flags.
0385 02F2              p_wtitle equ   p_wframe+2               Pointer to window's title.
0386 02F2              p_wrefCon equ   p_wtitle+4              Reserved for application.
0387 02F2              p_wfull  equ   p_wrefCon+4              Size of window, used with ZoomWindow.
0388 02F2              p_wcolor equ   p_wfull+8                Pointer to window's color table.
0389 02F2              p_y_origin equ   p_wcolor+4             Content's vertical offset.
0390 02F2              p_x_origin equ   p_y_origin+2           Content's horizontal offset.
0391 02F2              p_data_h equ   p_x_origin+2             Height of total data area.
0392 02F2              p_data_w equ   p_data_h+2               Width of total data area.
0393 02F2              p_wmaxheight equ   p_data_w+2
0394 02F2              p_wmaxwidth equ   p_wmaxheight+2
0395 02F2              p_vscroll equ   p_wmaxwidth+2           Amount to scroll vertically (arrows).
0396 02F2              p_hscroll equ   p_vscroll+2             Amount to scroll horizonally (arrows).
0397 02F2              p_vpage  equ   p_hscroll+2              Amount to page vertically (page region).
0398 02F2              p_hpage  equ   p_vpage+2                Amount to page horizontally (page rgn).
0399 02F2              p_wInfoText equ   p_hpage+2
0400 02F2              p_wInfoH equ   p_wInfoText+4            Height of infomation bar.
0401 02F2              p_wdefProc equ   p_wInfoH+2             NOT USED.
0402 02F2              p_wInfoDraw equ   p_wdefProc+4          Address of routine to draw Info Bar.
0403 02F2              p_updateDraw equ   p_wInfoDraw+4        Address of routine to draw content region.
0404 02F2              p_position equ   p_updateDraw+4
0405 02F2              p_behind equ   p_position+8
0406 02F2              p_windrec equ   p_behind+4              control template 
0407 02F2              p_wInVerbs equ   p_windrec+4            Input verbs describing title,color tbl, and ctl template
0408 02F2              p_size   equ   p_wInVerbs+2
0409 02F2              ;
0410 02F2              ;
0411 02F2              ; --- Resource types.
0412 02F2              ;
0413 02F2              rPString equ   $8006
0414 02F2              rWindParam1 equ   $800E
0415 02F2              rWindParam2 equ   $800F
0416 02F2              rWindColor equ   $8010
0417 02F2              ;
0418 02F2              ;
0419 02F2              ; --- Input verbEquates
0420 02F2              resIDVAsPtr equ   0
0421 02F2              resIDVAsHandle equ   1
0422 02F2              resIDVAsResource equ   2
0423 02F2              ;
0424 02F2              ; --- parmameter template verb word equates
0425 02F2              ; the first byte is the same as the verb for NewControl2 call
0426 02F2              titleAsPtr equ   $0000
0427 02F2              titleAsHandle equ   $0100
0428 02F2              titleAsResource equ   $0200
0429 02F2              colorAsPtr equ   $0000
0430 02F2              colorAsHandle equ   $0400
0431 02F2              colorAsResource equ   $0800
0432 02F2              ;
0433 02F2              ;
0434 02F2              ; --- Direct page offsets.
0435 02F2              ;
0436 02F2              @ID      equ   1
0437 02F2              @hand    equ   @ID+4
0438 02F2              @ptr     equ   @hand+4
0439 02F2              @paramPtr equ   @ptr+4
0440 02F2              @memoryID equ   @paramPtr+4
0441 02F2              ;
0442 02F2              @saveDbank equ   @memoryID+2
0443 02F2              @saveDpage equ   @saveDbank+1
0444 02F2              @retAddrs equ   @saveDpage+2
0445 02F2              @resType equ   @retAddrs+6
0446 02F2              @resID   equ   @resType+2
0447 02F2              @resIDVerb equ   @resID+4               ; added 12/12/88 Mensch
0448 02F2              @defProc equ   @resIDVerb+2
0449 02F2              @contentDraw equ   @defProc+4
0450 02F2              @refCon  equ   @contentDraw+4
0451 02F2              @title   equ   @refCon+4
0452 02F2              @result  equ   @title+4
0453 02F2              ;
0454 02F2 22 64 00 E1           jsl   IncBusyFlg
0455 02F6 0B                    phd                            ;Save caller's direct page pointer.
0456 02F7 8B                    phb                            ;Save caller's data bank pointer.
0457 02F8              ;
0458 02F8 4B                    phk                            ;Switch data bank to program bank.
0459 02F9 AB                    plb   
0460 02FA              ;
0461 02FA 5B                    tcd                            ;Switch to Window Manager's direct page.
0462 02FB              ;
0463 02FB 3B                    tsc   
0464 02FC D4 DC                 pei   <MyID                    ;Put memory ID on my page.
0465 02FE              ;
0466 02FE 38                    sec                            ;Switch direct page into stack.
0467 02FF E9 12 00              sbc   #@saveDbank-1
0468 0302 1B                    tcs   
0469 0303 5B                    tcd   
0470 0304              ;
0471 0304 64 34                 stz   <@result                 ;Start with no window, just in case.
0472 0306 64 36                 stz   <@result+2
0473 0308              ;
0474 0308              ;
0475 0308              ; --- Test InputVerb to determine the method of parm passing
0476 0308              ;
0477 0308 A5 22                 lda   <@resIDVerb              ;get the passed verb
0478 030A C9 02 00              cmp   #resIDVAsResource
0479 030D F0 4E                 beq   @ResIDIsRes              ;If passed as resource, go load it 
0480 030F              ; if neither of these, then passed by handle or pointer, first allocate temp storage
0481 030F              ; to copy the users template into
0482 030F A9 50 00              lda   #p_size                  ;template size.
0483 0312 A4 11                 ldy   <@memoryID
0484 0314 A2 00 80              ldx   #$8000                   ;pass attributes in <X> (Locked)
0485 0317 20 17 09              jsr   allocate3                ;Allocate memory for template.
0486 031A 85 05                 sta   <@hand
0487 031C 86 07                 stx   <@hand+2
0488 031E A7 05                 lda   [<@hand]                 ;deref the handle now...
0489 0320 AA                    tax   
0490 0321 A0 02 00              ldy   #2
0491 0324 B7 05                 lda   [<@hand],y
0492 0326 85 0F                 sta   <@ParamPtr+2
0493 0328 86 0D                 stx   <@ParamPtr
0494 032A
0495 032A A5 22                 lda   <@resIDVerb              ;get the res ID verb again
0496 032C F0 18                 beq   @ResIDIsPtr              ;if pointer, then pass it...
0497 032E
0498 032E              ; if it gets here the user passed us a handle, so copy the data now...
0499 032E D4 20                 pei   <@resID+2                ;Pass handle to copy from
0500 0330 D4 1E                 pei   <@resID
0501 0332 D4 0F                 pei   <@ParamPtr+2             ;pass the handle to copy to
0502 0334 D4 0D                 pei   <@ParamPtr
0503 0336 F4 00 00              pea   $0000                    ;now pass the size
0504 0339 F4 50 00              pea   p_size                   ;to copy
0505 033C A2 02 29 22           _handToPtr 
0506 0343 82 47 00              brl   @TD0010
0507 0346              ;
0508 0346              ; --- New template ref was passed by pointer, so just copy the pointer
0509 0346              ;
0510 0346              @ResIDIsPtr  
0511 0346 D4 20                 pei   <@ResID+2                ;pointer to the source parm block
0512 0348 D4 1E                 pei   <@ResID
0513 034A D4 0F                 pei   <@paramPtr+2             ;pointer to destination
0514 034C D4 0D                 pei   <@paramPtr
0515 034E F4 00 00              pea   $0000
0516 0351 F4 50 00              pea   p_size
0517 0354 A2 02 2B 22           _BlockMove                     ;copy the data
0518 035B 80 30                 bra   @TD0010                  ;and continue
0519 035D
0520 035D              ; 
0521 035D              ; --- Load new window parameter table resource.
0522 035D              ;
0523 035D              @ResIDIsRes  
0524 035D 48                    pha                            ;Space for result.
0525 035E 48                    pha   
0526 035F D4 1C                 pei   <@resType                ;Pass type.
0527 0361 D4 20                 pei   <@resID+2                ;Pass ID.
0528 0363 D4 1E                 pei   <@resID
0529 0365 A2 1E 0E 22           _LoadResource 
0530 036C A8                    tay                            ;Possible error code in y.
0531 036D FA                    plx   
0532 036E 86 0D                 stx   <@paramPtr
0533 0370 FA                    plx   
0534 0371 86 0F                 stx   <@paramPtr+2
0535 0373 90 03                 bcc   @ok2                     ;Error?
0536 0375 82 B2 00     @toExit2 brl   @exit2                   ;Error.
0537 0378              @ok2      
0538 0378              ;
0539 0378              ; Now, take the handle from resource mgr or passed by app and dereference it.
0540 0378              @TemplateDeref  
0541 0378 A0 04 00              ldy   #4                       ;Lock parameter table.
0542 037B B7 0D                 lda   [<@paramPtr],y
0543 037D 09 00 80              ora   #$8000
0544 0380 97 0D                 sta   [<@paramPtr],y
0545 0382 88                    dey                            ;Dereference the table.
0546 0383 88                    dey   
0547 0384 B7 0D                 lda   [<@paramPtr],y
0548 0386 A8                    tay   
0549 0387 A7 0D                 lda   [<@paramPtr]
0550 0389 85 0D                 sta   <@paramPtr
0551 038B 84 0F                 sty   <@paramPtr+2
0552 038D              @TD0010   
0553 038D              ;
0554 038D              ;
0555 038D              ; --- Fix up parameter table.
0556 038D              ;
0557 038D A5 1C                 lda   <@resType                ;Which kind of parameter table?
0558 038F C9 0E 80              cmp   #rWindParam1
0559 0392 F0 05                 beq   @doParam1
0560 0394              ;
0561 0394 20 FC 08              jsr   @fixParam2
0562 0397 80 03                 bra   @done1
0563 0399              ;
0564 0399 20 58 07     @doParam1 jsr   @fixParam1
0565 039C 98           @done1   tya                            ;Place possible error code in A.
0566 039D B0 1B                 bcs   @errOut                  ;Error?
0567 039F              ;
0568 039F              ;
0569 039F              ; --- Have NewWindow create the window.
0570 039F              ;
0571 039F              ; First adjust parameter list count back to new window size...
0572 039F A7 0D                 lda   [<@paramPtr]             ;remove the input verb from the parm count
0573 03A1 3A                    dec   a
0574 03A2 3A                    dec   a
0575 03A3 87 0D                 sta   [<@paramPtr]
0576 03A5
0577 03A5 48                    pha                            ;Save for result.
0578 03A6 48                    pha   
0579 03A7 D4 0F                 pei   <@paramPtr+2             ;Pass pointer to parameter table.
0580 03A9 D4 0D                 pei   <@paramPtr
0581 03AB A2 0E 09 22           _NewWindow 
0582 03B2 7A                    ply                            ;Return window pointer.
0583 03B3 84 34                 sty   <@result
0584 03B5 7A                    ply   
0585 03B6 84 36                 sty   <@result+2
0586 03B8 90 15                 bcc   @skip1                   ;Error? a = error code if any.
0587 03BA              ;
0588 03BA 48           @errOut  pha                            ;Save error code.
0589 03BB              ;
0590 03BB A5 1C                 lda   <@resType                ;Free items allocated by me.
0591 03BD C9 0E 80              cmp   #rWindParam1
0592 03C0 D0 0C                 bne   @skip3                   ;Only for parameter table type 1.
0593 03C2              ;
0594 03C2 A0 06 00              ldy   #p_wtitle+2              ;Free title if there is one.
0595 03C5 20 43 07              jsr   @freeField
0596 03C8              ;
0597 03C8 A0 16 00              ldy   #p_wcolor+2              ;Free the color table if there is one.
0598 03CB 20 43 07              jsr   @freeField
0599 03CE              ;
0600 03CE 68           @skip3   pla                            ;Restore error code.
0601 03CF              ;
0602 03CF              ;
0603 03CF              ; --- Free parameter table.
0604 03CF              ;
0605 03CF 48           @skip1   pha                            ;Save error code.
0606 03D0              ;
0607 03D0 A5 22                 lda   <@resIDVerb              ;get the passed verb
0608 03D2 C9 02 00              cmp   #resIDVAsResource
0609 03D5 F0 16                 beq   @DumpRes                 ;If passed as resource, release it...
0610 03D7              ; If not a resource, then I made a copy of the passed param block and I should 
0611 03D7              ; dispose of it right now...
0612 03D7 48                    pha                            ;room for result
0613 03D8 48                    pha   
0614 03D9 D4 0F                 pei   <@paramPtr+2             ;first get the handle back for the temp parm block
0615 03DB D4 0D                 pei   <@paramPtr
0616 03DD A2 02 1A 22           _FindHandle                    ;get the handle back
0617 03E4 A2 02 10 22           _DisposeHandle                 ;and get rid of it.
0618 03EB 80 10                 bra   @MkCtrls
0619 03ED              ;
0620 03ED              @DumpRes  
0621 03ED F4 FF FF              pea   $FFFF                    ;Pass 'dispose' flag.
0622 03F0 D4 1C                 pei   <@resType                ;Pass type.
0623 03F2 D4 20                 pei   <@resID+2                ;Pass ID.
0624 03F4 D4 1E                 pei   <@resID
0625 03F6 A2 1E 17 22           _ReleaseResource 
0626 03FD              ;
0627 03FD              ;
0628 03FD              ; --- Create controls in window. Use the low order byte of the wInVerb as the
0629 03FD              ;     input verb for this call.
0630 03FD              ;
0631 03FD              @MkCtrls  
0632 03FD A5 01                 lda   <@ID                     ;Is there a control list?
0633 03FF 05 03                 ora   <@ID+2
0634 0401 F0 26                 beq   @skip2
0635 0403              ;
0636 0403 A5 34                 lda   <@result                 ;Was a window created?
0637 0405 05 36                 ora   <@result+2
0638 0407 F0 20                 beq   @skip2
0639 0409              ;
0640 0409 48                    pha                            ;Space for result.
0641 040A 48                    pha   
0642 040B D4 36                 pei   <@result+2               ;Pass window owner.
0643 040D D4 34                 pei   <@result
0644 040F A0 4E 00              ldy   #p_wInVerbs              ;load the offset to the template verbs
0645 0412 B7 0D                 lda   [<@paramPtr],y           ;load in the input verb
0646 0414 29 FF 00              and   #$00FF                   ;strip off the high byte, low byte for this call
0647 0417 48                    pha                            ;and pass it as inputverb for NewControl2
0648 0418 D4 03                 pei   <@ID+2                   ;Pass ID of item list.
0649 041A D4 01                 pei   <@ID
0650 041C A2 10 31 22           _NewControl2 
0651 0423 FA                    plx                            ;Don't need result.
0652 0424 FA                    plx   
0653 0425 90 02                 bcc   @skip2                   ;Error?
0654 0427 83 01                 sta   1,s                      ;Replace saved error code with error from NewControl2.
0655 0429              ;
0656 0429 7A           @skip2   ply                            ;Restore error code from NewWindow.
0657 042A              ;
0658 042A              ;
0659 042A              ; --- Clean up stack and exit.
0660 042A              ;      mod 12/12/88 pull off 24 bytes parameter. Mensch
0661 042A              ;
0662 042A 3B           @exit2   tsc                            ;Free allocated direct page.
0663 042B 18                    clc   
0664 042C 69 12 00              adc   #@saveDbank-1
0665 042F 1B                    tcs   
0666 0430 A2 18 00              ldx   #24                      ;Number of bytes to pop.
0667 0433 5C 01 90 FD           jml   $fd9001                  ;"shutDown" in ROM 3
0668 0437
0669 0437 08 00 32 00  @desIndex DC W:p_wrefCon,p_wdefProc,p_updateDraw
0670 043D 2C 00 24 00  @srcIndex DC W:@refCon,@defProc,@contentDraw
0671 0443
0672 0443
0673 0443              ;-----------------------------------------------
0674 0443              ;        Free handle in parameter table.
0675 0443              ;-----------------------------------------------
0676 0443              ;
0677 0443              ;   IN: y = index to high word of field.  If highest bit set it is a handle to free.
0678 0443              ;
0679 0443 B7 0D        @freeField lda   [<@paramPtr],y
0680 0445 10 10                 bpl   @exit100
0681 0447              ;
0682 0447 29 FF 00              and   #$00FF
0683 044A 48                    pha   
0684 044B 88                    dey   
0685 044C 88                    dey   
0686 044D B7 0D                 lda   [<@paramPtr],y
0687 044F 48                    pha   
0688 0450 A2 02 10 22           _DisposeHandle 
0689 0457 60           @exit100 rts   
0690 0458              ;
0691 0458              ;
0692 0458              ;---------------------------------------------------------------------
0693 0458              ;                   Fix up parameter table type 1.
0694 0458              ;-200-----------------------------------------------------------------
0695 0458              ;
0696 0458              ;  OUT:  Carry set if error, y = error code.
0697 0458              ;        <@ID = ID of control list, NIL if none.
0698 0458              ;
0699 0458 64 01        @fixParam1 stz   <@ID                   ;Start with no controls.
0700 045A 64 03                 stz   <@ID+2
0701 045C              ;
0702 045C              ;
0703 045C              ; --- Set window title in table.
0704 045C              ;
0705 045C A5 30                 lda   <@title                  ;Was a title passed?
0706 045E 05 32                 ora   <@title+2
0707 0460 F0 35                 beq   @loadTitle               ;Use the passed title if there is one.
0708 0462              ;
0709 0462              ;
0710 0462              ; ------ Clone the given title.
0711 0462              ;
0712 0462              @Clonetitle  
0713 0462 A7 30                 lda   [<@title]                ;Compute size of string,
0714 0464 29 FF 00              and   #$00FF
0715 0467 1A                    inc   a                        ;including length byte.
0716 0468 48                    pha                            ;Save size.
0717 0469 A4 11                 ldy   <@memoryID
0718 046B 20 0F 09              jsr   allocate1                ;Allocate fixed memory for title.
0719 046E 85 05                 sta   <@hand
0720 0470 86 07                 stx   <@hand+2
0721 0472              ;
0722 0472 7A                    ply                            ;Restore size of string.
0723 0473              ;
0724 0473 D4 32                 pei   <@title+2                ;Pass source pointer.
0725 0475 D4 30                 pei   <@title
0726 0477 DA                    phx                            ;Pass destination handle.
0727 0478 48                    pha   
0728 0479 F4 00 00              pea   0                        ;Pass number of bytes to move.
0729 047C 5A                    phy   
0730 047D A2 02 28 22           _PtrToHand                     ;Clone title.
0731 0484              ;
0732 0484 A0 04 00              ldy   #p_wtitle                ;Store handle of title.
0733 0487 A5 05                 lda   <@hand
0734 0489 97 0D                 sta   [<@paramPtr],y
0735 048B C8                    iny   
0736 048C C8                    iny   
0737 048D A5 07                 lda   <@hand+2
0738 048F 09 00 80              ora   #$8000                   ;Set bit that states this is a handle.
0739 0492 97 0D                 sta   [<@paramPtr],y
0740 0494 82 81 00              brl   @noTitle
0741 0497              ;
0742 0497              ;
0743 0497              ; ------ Load title from wherever.
0744 0497              ;
0745 0497 A0 06 00     @loadTitle ldy   #p_wtitle+2            ;Is there a title in the template?
0746 049A B7 0D                 lda   [<@paramPtr],y
0747 049C AA                    tax   
0748 049D 88                    dey   
0749 049E 88                    dey   
0750 049F 17 0D                 ora   [<@paramPtr],y
0751 04A1 F0 75                 beq   @noTitle
0752 04A3              ;
0753 04A3 A0 4E 00              ldy   #p_wInVerbs              ;get the input verbs
0754 04A6 B7 0D                 lda   [<@paramPtr],y
0755 04A8 A8                    tay                            ;and save em for a second
0756 04A9 29 00 02              and   #titleAsResource
0757 04AC D0 32                 bne   @LoadTByRes              ;if by resource load it
0758 04AE 98                    tya   
0759 04AF 29 00 01              and   #titleAsHandle
0760 04B2 D0 10                 bne   @LoadTByHandle
0761 04B4 A0 06 00              ldy   #p_wtitle+2
0762 04B7 B7 0D                 lda   [<@paramPtr],y           ;load the pointer
0763 04B9 85 32                 sta   <@title+2                ;save it in the string pointer field
0764 04BB 88                    dey   
0765 04BC 88                    dey   
0766 04BD B7 0D                 lda   [<@paramPtr],y
0767 04BF 85 30                 sta   <@title
0768 04C1 82 9E FF              brl   @Clonetitle              ;now create a buffer and copy the title
0769 04C4              @LoadTByHandle  
0770 04C4 A0 06 00              ldy   #p_wtitle+2
0771 04C7 B7 0D                 lda   [<@paramPtr],y           ;load the pointer
0772 04C9 85 32                 sta   <@title+2                ;save it in the string pointer field
0773 04CB 88                    dey   
0774 04CC 88                    dey   
0775 04CD B7 0D                 lda   [<@paramPtr],y
0776 04CF 85 30                 sta   <@title
0777 04D1 A0 02 00              ldy   #2
0778 04D4 B7 30                 lda   [<@title],y
0779 04D6 A8                    tay   
0780 04D7 A7 30                 lda   [<@title]
0781 04D9 85 30                 sta   <@title
0782 04DB 84 32                 sty   <@title+2
0783 04DD 82 82 FF              brl   @Clonetitle
0784 04E0              @LoadTByRes  
0785 04E0 A0 04 00              ldy   #p_wtitle
0786 04E3 48                    pha                            ;Space for result.
0787 04E4 48                    pha   
0788 04E5 F4 06 80              pea   rPString                 ;Pass type.
0789 04E8 DA                    phx                            ;Pass ID.
0790 04E9 B7 0D                 lda   [<@paramPtr],y
0791 04EB 48                    pha   
0792 04EC 85 01                 sta   <@ID                     ;Remember ID.
0793 04EE 86 03                 stx   <@ID+2
0794 04F0 A2 1E 0E 22           _LoadResource 
0795 04F7 A8                    tay                            ;Posible error code.
0796 04F8 68                    pla   
0797 04F9 FA                    plx   
0798 04FA 90 01                 bcc   @ok200                   ;Error?
0799 04FC 60           @errOut200 rts                          ;Error.
0800 04FD              @ok200    
0801 04FD              ;
0802 04FD A0 04 00              ldy   #p_wtitle                ;Store handle of title.
0803 0500 97 0D                 sta   [<@paramPtr],y
0804 0502 C8                    iny   
0805 0503 C8                    iny   
0806 0504 8A                    txa   
0807 0505 09 00 80              ora   #$8000                   ;Set bit that states this is a handle.
0808 0508 97 0D                 sta   [<@paramPtr],y
0809 050A              ;
0810 050A F4 06 80              pea   rPString                 ;Pass type.
0811 050D D4 03                 pei   <@ID+2                   ;Pass ID.
0812 050F D4 01                 pei   <@ID
0813 0511 A2 1E 18 22           _DetachResource                ;Unlink the title handle from resource.
0814 0518              ;
0815 0518              @noTitle  
0816 0518              ;
0817 0518              ;
0818 0518              ; --- Set window color table pointer in table.
0819 0518              ;
0820 0518 A0 16 00              ldy   #p_wcolor+2              ;Is there a color table resource?
0821 051B B7 0D                 lda   [<@paramPtr],y
0822 051D AA                    tax   
0823 051E 88                    dey   
0824 051F 88                    dey   
0825 0520 17 0D                 ora   [<@paramPtr],y
0826 0522 D0 03                 bne   @LCT0005
0827 0524 82 A3 00              brl   @noColor
0828 0527              ;
0829 0527              @LCT0005  
0830 0527 A0 4E 00              ldy   #p_wInVerbs              ;get the input verbs
0831 052A B7 0D                 lda   [<@paramPtr],y
0832 052C 29 00 08              and   #colorAsResource
0833 052F D0 6D                 bne   @LoadCByRes              ;if by resource load it
0834 0531
0835 0531              @ColorTableHandle                       ;come back here when creating by resource
0836 0531              ;
0837 0531              ; If not passed by resource ID we will have to make a copy of the color table
0838 0531              ; so first create a handle
0839 0531 A9 00 00              lda   #$0000
0840 0534 48                    pha                            ;room for result
0841 0535 48                    pha   
0842 0536 48                    pha                            ;zero for high word of size
0843 0537 F4 0A 00              pea   $000A                    ;room for a color table
0844 053A D4 11                 pei   <@memoryID
0845 053C              ***	pha		;zero for attributes
0846 053C F4 00 C0              pea   $c000                    ;locked and fixed! (21-May-91 DAL)
0847 053F 48                    pha                            ;no specific location
0848 0540 48                    pha   
0849 0541 A2 02 09 22           _NewHandle                     ;allocate the space 
0850 0548 A8                    tay                            ;Possible error code.
0851 0549 68                    pla   
0852 054A 85 01                 sta   <@ID                     ;save the handle for a sec...
0853 054C 68                    pla   
0854 054D 85 03                 sta   <@ID+2
0855 054F B0 AB                 bcs   @errOut200               ;Error?
0856 0551
0857 0551 A0 16 00              ldy   #p_wcolor+2              ;push ref of the color table.
0858 0554 B7 0D                 lda   [<@paramPtr],y
0859 0556 48                    pha   
0860 0557 88                    dey   
0861 0558 88                    dey   
0862 0559 B7 0D                 lda   [<@paramPtr],y
0863 055B 48                    pha   
0864 055C D4 03                 pei   <@ID+2                   ;address to copy to
0865 055E D4 01                 pei   <@ID
0866 0560 F4 00 00              pea   $0000                    ;size to copy
0867 0563 F4 0A 00              pea   $000A
0868 0566              ;
0869 0566              ; Now that the parms are set up properly, let's copy the right way depending on
0870 0566              ; the input verb
0871 0566              ;
0872 0566 A0 4E 00              ldy   #p_wInVerbs              ;get the input verbs
0873 0569 B7 0D                 lda   [<@paramPtr],y
0874 056B              ***	and	#colorAsHandle
0875 056B 29 00 0C              and   #colorAsHandle+colorAsResource ;21-May-91 DAL
0876 056E D0 09                 bne   @LoadCByHandle
0877 0570 A2 02 28 22           _PtrToHand                     ;copy the data from ptr to our handle
0878 0577 80 07                 bra   @LCT0020
0879 0579              ;
0880 0579              @LoadCByHandle  
0881 0579 A2 02 2A 22           _HandToHand                    ;copy the data from handle to handle
0882 0580              @LCT0020  
0883 0580              *** 21-May-91 DAL -- deref ID into pointer
0884 0580 A0 02 00              ldy   #2
0885 0583 B7 01                 lda   [<@ID],y
0886 0585 A8                    tay   
0887 0586 A7 01                 lda   [<@ID]
0888 0588 85 01                 sta   <@ID
0889 058A 84 03                 sty   <@ID+2
0890 058C              *** end of 21-May-91
0891 058C A0 16 00              ldy   #p_wcolor+2              ;offset to high word of color table
0892 058F A5 03                 lda   <@ID+2                   ;high byte of our handle
0893 0591              ***	ora	#$8000	;set high bit to indicate by handle
0894 0591 09 00 40              ora   #$4000                   ;set bit 30: ptr that we need to dispose (21-May-91 DAL)
0895 0594 97 0D                 sta   [<@paramPtr],y
0896 0596 88                    dey   
0897 0597 88                    dey   
0898 0598 A5 01                 lda   <@ID
0899 059A 97 0D                 sta   [<@paramPtr],y
0900 059C 80 2C                 bra   @noColor
0901 059E              @LoadCByRes  
0902 059E A0 14 00              ldy   #p_wcolor
0903 05A1 48                    pha                            ;Space for result.
0904 05A2 48                    pha   
0905 05A3 F4 10 80              pea   rWindColor               ;Pass type.
0906 05A6 DA                    phx                            ;Pass ID.
0907 05A7 B7 0D                 lda   [<@paramPtr],y
0908 05A9 48                    pha   
0909 05AA 85 01                 sta   <@ID                     ;Remember ID.
0910 05AC 86 03                 stx   <@ID+2
0911 05AE A2 1E 0E 22           _LoadResource 
0912 05B5 A8                    tay                            ;Possible error code.
0913 05B6 68                    pla   
0914 05B7 FA                    plx   
0915 05B8 90 03                 bcc   @okByRes
0916 05BA 82 3F FF              brl   @errOut200               ;Error.
0917 05BD
0918 05BD              *** added 21-May-91 DAL -- treat color table resource just like handle
0919 05BD A0 14 00     @okByRes ldy   #p_wcolor
0920 05C0 97 0D                 sta   [<@paramPtr],y
0921 05C2 8A                    txa   
0922 05C3 C8                    iny   
0923 05C4 C8                    iny   
0924 05C5 97 0D                 sta   [<@paramPtr],y
0925 05C7 82 67 FF              brl   @ColorTableHandle
0926 05CA              *** end of 21-May-91 DAL
0927 05CA
0928 05CA              ;@LCT0030
0929 05CA              ;	ldy	#p_wcolor	;Store handle of the color table.
0930 05CA              ;	sta	[<@paramPtr],y
0931 05CA              ;	iny
0932 05CA              ;	iny
0933 05CA              ;	txa
0934 05CA              ;	ora	#$8000	;Set bit that states this is a handle.
0935 05CA              ;	sta	[<@paramPtr],y
0936 05CA              ;
0937 05CA              ;	pea	rWindColor	;Pass type.
0938 05CA              ;	pei	<@ID+2	;Pass ID.
0939 05CA              ;	pei	<@ID
0940 05CA              ;	_DetachResource	;Unlink color table handle from resource.
0941 05CA
0942 05CA              @noColor  
0943 05CA              ;
0944 05CA              ;
0945 05CA              ; --- Store passed values in parameter table.
0946 05CA              ;
0947 05CA A2 04 00              ldx   #4
0948 05CD DA           @lop200  phx   
0949 05CE
0950 05CE BC 37 07              ldy   |@desIndex,x
0951 05D1 BD 3D 07              lda   |@srcIndex,x
0952 05D4 AA                    tax   
0953 05D5
0954 05D5 B5 00                 lda   <0,x
0955 05D7 97 0D                 sta   [<@paramPtr],y
0956 05D9 C8                    iny   
0957 05DA C8                    iny   
0958 05DB B5 02                 lda   <2,x
0959 05DD 97 0D                 sta   [<@paramPtr],y
0960 05DF
0961 05DF FA                    plx   
0962 05E0 CA                    dex   
0963 05E1 CA                    dex   
0964 05E2 10 E9                 bpl   @lop200
0965 05E4
0966 05E4              ;
0967 05E4              ; --- Get ID of control list.
0968 05E4              ;
0969 05E4 A2 00 00              ldx   #0
0970 05E7 A0 4A 00              ldy   #p_windrec
0971 05EA B7 0D                 lda   [<@paramPtr],y           ;Get the ID of the window's control list.
0972 05EC 85 01                 sta   <@ID
0973 05EE 8A                    txa   
0974 05EF 97 0D                 sta   [<@paramPtr],y           ;Clear the windRec field also, window record to be 
0975 05F1 C8                    iny                            ;allocated.
0976 05F2 C8                    iny   
0977 05F3 B7 0D                 lda   [<@paramPtr],y
0978 05F5 85 03                 sta   <@ID+2
0979 05F7 8A                    txa   
0980 05F8 97 0D                 sta   [<@paramPtr],y
0981 05FA 18                    clc                            ;No error.
0982 05FB 60                    rts   
0983 05FC
0984 05FC
0985 05FC              ;---------------------------------------------------------------------
0986 05FC              ;                   Fix up parameter table type 2.
0987 05FC              ;-300-----------------------------------------------------------------
0988 05FC              ;
0989 05FC              ;  OUT:  Carry set if error, y = error code.
0990 05FC              ;        <@ID = ID of control list, NIL if none.
0991 05FC              ;
0992 05FC              @fixParam2  
0993 05FC              ;
0994 05FC              ; --- New parameter list offsets -----------------------------
0995 05FC              ;
0996 05FC              @paramID equ   0                        ;ID of parameter list.
0997 05FC              @newDefProc equ   @paramID+2            ;DefProc of window.
0998 05FC              @newData equ   @newDefProc+4            ;Additional data for new window.
0999 05FC
1000 05FC 64 01                 stz   <@ID                     ;No control list.
1001 05FE 64 03                 stz   <@ID+2
1002 0600
1003 0600 A0 02 00              ldy   #@newDefProc             ;Store address of defProc.
1004 0603 A5 24                 lda   <@defProc
1005 0605 97 0D                 sta   [<@paramPtr],y
1006 0607 C8                    iny   
1007 0608 C8                    iny   
1008 0609 A5 26                 lda   <@defProc+2
1009 060B 97 0D                 sta   [<@paramPtr],y
1010 060D
1011 060D 18                    clc                            ;No error.
1012 060E 60                    rts   
1013 060F
1014 060F              ;==========================================================================
1015 060F              ;
1016 060F              ;          Allocate a block of memory.
1017 060F              ;
1018 060F              ;   IN:    y = ID number.
1019 060F              ;          a = number of bytes.
1020 060F              ;
1021 060F              ;  OUT:    Carry clear if handle allocated, a+x = handle.
1022 060F              ;          Carry set if error, y = error returned by Memory Manager.
1023 060F              ;
1024 060F              ;==========================================================================
1025 060F A2 00 00     allocate1 ldx   #0                      Anywhere, anyhow.
1026 0612 80 03                 bra   allocate3
1027 0614
1028 0614                       EXPORT allocate2 
1029 0614 A2 10 40     allocate2 ldx   #%0100000000010000      Fixed, May not cross bank boundary.
1030 0617
1031 0617              ; = = = = = = = = = = = = = = = = = = = = = = = =
1032 0617              ;          Allocate a block of memory.
1033 0617              ; = = = = = = = = = = = = = = = = = = = = = = = =
1034 0617              ;
1035 0617              ;   IN:    y = ID number.
1036 0617              ;          x = attributes.
1037 0617              ;          a = number of bytes.
1038 0617              ;
1039 0617              ;  OUT:    Carry clear if handle allocated, a+x = handle.
1040 0617              ;          Carry set if error, y = error returned by Memory Manager.
1041 0617              ;
1042 0617 48           allocate3 pha                           Space for returned handle.
1043 0618 48                    pha   
1044 0619 F4 00 00              pea   0                        High word of size.
1045 061C 48                    pha                            Pass low word of size.
1046 061D 5A                    phy                            Pass ID number.
1047 061E DA                    phx                            Pass attributes.
1048 061F 48                    pha                            Address doesn't matter.
1049 0620 48                    pha   
1050 0621 A2 02 09 22           _NewHandle 
1051 0628 A8                    tay                            Return error code in Y.
1052 0629 68                    pla                            Return handle in a+x.
1053 062A FA                    plx   
1054 062B
1055 062B 60                    rts   
1056 062C
1057 062C                       EndP 
1058 062C
1059 062C
1060 062C              ********************************************************
1061 062C              *
1062 062C              * ErrorWindow patch
1063 062C              *
1064 062C              * 22-Sep-90 DAL (new patch)
1065 062C              *
1066 062C              * Just need to make the carry be clear on exit if there
1067 062C              * was no error.  (The ROM is doing a CMP #0 when it meant
1068 062C              * to CMP #1, so the carry is always being returned set.)
1069 062C              *
1070 062C              ********************************************************
1071 062C              ErrorWindow PROC 
1072 062C              ;
1073 062C              ; 9-Mar-91 DAL -- call SysBeep2 if the error code is 0..FF
1074 062C              ; (25-Mar-91 DAL: sucked in the $CEFF thing from WindMgr.asm)
1075 062C              ;
1076 062C              errorNum equ   7                        ;stack-relative
1077 062C
1078 062C A3 07                 lda   errorNum,s
1079 062E 29 00 FF              and   #$ff00
1080 0631 F0 05                 beq   @inRange
1081 0633
1082 0633 A9 FF CE              lda   #$CEFF
1083 0636 80 05                 bra   @thisBeep
1084 0638
1085 0638 A3 07        @inRange lda   errorNum,s
1086 063A 09 00 CE              ora   #$CE00                   ;default silent, defer to GNE, beep $0Exx
1087 063D 48           @thisBeep pha   
1088 063E A2 03 38 22           _SysBeep2 
1089 0645
1090 0645              ; push a copy of the passed parameters
1091 0645 A2 05 00              ldx   #5                       ;5 words to push (including result space)
1092 0648 A3 0F        @pushParms lda   15,s
1093 064A 48                    pha   
1094 064B CA                    dex   
1095 064C D0 FA                 bne   @pushParms
1096 064E 22 5D 09 02           jsl   ToROMErrorWindow
1097 0652 AA                    tax                            ;error code
1098 0653 68                    pla                            ;result: Button number
1099 0654 83 0F                 sta   15,s
1100 0656 A0 08 00              ldy   #8                       ;strip 8 bytes
1101 0659 5C 84 01 E1           jml   $e10184                  ;ToStrip (error code in X)
1102 065D
1103 065D 22 5E 38 FD  ToROMErrorWindow jsl   $fd385e          ;doesn't need A/X/Y!
1104 0661 6B                    rtl   
1105 0662
1106 0662                       EndP 
1107 0662
1108 0662              ********************************************************
1109 0662              *
1110 0662              * CloseWindow patch
1111 0662              *
1112 0662              * 28-Feb-91 DAL (new patch)
1113 0662              *
1114 0662              * Pre-patch to kill the AuxWindInfo record for this
1115 0662              * window, if any.
1116 0662              *
1117 0662              ********************************************************
1118 0662              CloseWindow proc 
1119 0662                       import KillAuxInfoRecord 
1120 0662                       import KillColorTable 
1121 0662
1122 0662 0B                    phd                            ;save caller's direct page
1123 0663 5B                    tcd                            ;and use ours
1124 0664
1125 0664 A3 0B                 lda   11,s
1126 0666 03 09                 ora   9,s
1127 0668 F0 13                 beq   @nil
1128 066A
1129 066A A3 0B                 lda   11,s
1130 066C 48                    pha   
1131 066D A3 0B                 lda   11,s
1132 066F 48                    pha   
1133 0670 22 E6 1A 02           jsl   KillAuxInfoRecord
1134 0674
1135 0674              *** added 21-May-91 DAL
1136 0674 A3 0B                 lda   11,s
1137 0676 48                    pha   
1138 0677 A3 0B                 lda   11,s
1139 0679 48                    pha   
1140 067A 20 3F 0A              jsr   KillColorTable
1141 067D              *** end of 21-May-91 DAL
1142 067D
1143 067D 7B           @nil     tdc                            ;get direct page back in A
1144 067E 2B                    pld                            ;restore caller's direct page
1145 067F 5C FF 13 FD           jml   $fd13ff                  ;ROM 3 CloseWindow
1146 0683
1147 0683                       EndP 
1148 0683
1149 0683
1150 0683              ********************************************************
1151 0683              *
1152 0683              * Desktop patch
1153 0683              *
1154 0683              * 12-Dec-91 DAL (new patch)
1155 0683              *
1156 0683              * Post-patch Desktop(8) (new desk message) to call
1157 0683              * SendRequest(systemSaysNewDeskMsg) (reqcode 8).
1158 0683              *
1159 0683              * Also, dispose of old desktop pic/patt handle if
1160 0683              * it changes.
1161 0683              *
1162 0683              * Stack:
1163 0683              *  1,s = rtl
1164 0683              *  4,s = rtl
1165 0683              *  7,s = param (long)
1166 0683              * 11,s = message (word)
1167 0683              * 13,s = result space (long, optional)
1168 0683              *
1169 0683              * The result space is used when message = 2, 3, 4.
1170 0683              *
1171 0683              ********************************************************
1172 0683              ;deskPatt	equ	$92	;on WM direct page
1173 0683
1174 0683              Desktop  proc 
1175 0683 AA                    tax   
1176 0684 D0 05                 bne   @started
1177 0686 A9 02 00              lda   #2
1178 0689 38                    sec   
1179 068A 6B                    rtl   
1180 068B
1181 068B 8F 2E 0A 02  @started sta   >windDirPage
1182 068F BF 94 00 00           lda   >deskPatt+2,x
1183 0693 8F 2C 0A 02           sta   >oldDeskPatt+2
1184 0697 BF 92 00 00           lda   >deskPatt,x
1185 069B 8F 2A 0A 02           sta   >oldDeskPatt
1186 069F
1187 069F A0 05 00              ldy   #5
1188 06A2 A3 0F        @copyWord lda   15,s
1189 06A4 48                    pha   
1190 06A5 88                    dey   
1191 06A6 D0 FA                 bne   @copyWord
1192 06A8
1193 06A8 8A                    txa   
1194 06A9 22 23 0A 02           jsl   @toROM
1195 06AD 8F 28 0A 02           sta   >error
1196 06B1
1197 06B1 FA                    plx                            ;x = result low
1198 06B2 7A                    ply                            ;y = result high
1199 06B3
1200 06B3 A3 0B                 lda   11,s
1201 06B5 C9 02 00              cmp   #2
1202 06B8 90 0B                 bcc   @noResult
1203 06BA C9 05 00              cmp   #4+1
1204 06BD B0 06                 bcs   @noResult
1205 06BF 8A                    txa   
1206 06C0 83 0D                 sta   13,s
1207 06C2 98                    tya   
1208 06C3 83 0F                 sta   15,s
1209 06C5              @noResult  
1210 06C5
1211 06C5              *** If old desk patt was a handle & it changed, dispose it.
1212 06C5 AF 2E 0A 02           lda   >windDirPage
1213 06C9 AA                    tax   
1214 06CA BF 92 00 00           lda   >deskPatt,x
1215 06CE CF 2A 0A 02           cmp   >oldDeskPatt
1216 06D2 D0 0A                 bne   @changed
1217 06D4 BF 94 00 00           lda   >deskPatt+2,x
1218 06D8 CF 2C 0A 02           cmp   >oldDeskPatt+2
1219 06DC F0 20                 beq   @noChange
1220 06DE AF 2C 0A 02  @changed lda   >oldDeskPatt+2
1221 06E2 29 00 FF              and   #$ff00
1222 06E5 C9 00 01              cmp   #$0100
1223 06E8 D0 14                 bne   @notHandle
1224 06EA AF 2C 0A 02           lda   >oldDeskPatt+2
1225 06EE 29 FF 00              and   #$00ff
1226 06F1 48                    pha   
1227 06F2 AF 2A 0A 02           lda   >oldDeskPatt
1228 06F6 48                    pha   
1229 06F7 A2 02 10 22           _DisposeHandle 
1230 06FE              @notHandle  
1231 06FE              @noChange  
1232 06FE
1233 06FE              *** If this was a Desktop(8), inform everyone with SendRequest
1234 06FE A3 0B                 lda   11,s
1235 0700 C9 08 00              cmp   #8
1236 0703 D0 12                 bne   @notNewMess
1237 0705
1238 0705 48                    pha                            ;reqCode = 8 = systemSaysNewDeskMsg
1239 0706 A2 00 00              ldx   #0
1240 0709 DA                    phx                            ;sendToAll
1241 070A DA                    phx   
1242 070B DA                    phx                            ;target=NIL
1243 070C DA                    phx   
1244 070D DA                    phx                            ;dataIn=NIL
1245 070E DA                    phx   
1246 070F DA                    phx                            ;dataOut=NIL
1247 0710 A2 01 1C 22           _SendRequest 
1248 0717
1249 0717 AF 28 0A 02  @notNewMess lda   >error
1250 071B AA                    tax   
1251 071C A0 06 00              ldy   #6
1252 071F 5C 84 01 E1           jml   $e10184                  ;ToStrip
1253 0723
1254 0723 22 24 09 FD  @toROM   jsl   $fd0924
1255 0727 6B                    rtl   
1256 0728
1257 0728 00 00        error    DC W:0
1258 072A 00 00 00 00  oldDeskPatt DC L:0
1259 072E 00 00        windDirPage DC W:0
1260 0730
1261 0730                       EndP 
1262 0730
1263 0730              ********************************************************
1264 0730              *
1265 0730              * SetFrameColor patch
1266 0730              *
1267 0730              * 21-May-91 DAL (new patch)
1268 0730              *
1269 0730              * Pre-patch SetFrameColor to kill the old color table,
1270 0730              * if it's a standard window and the color table pointer
1271 0730              * has bit 30 set.
1272 0730              *
1273 0730              * SetFrameColor(@ColorTable,@Window)
1274 0730              *
1275 0730              * Note: Since we never documented anything about using
1276 0730              * SetFrameColor with bit 31 set to indicate a handle,
1277 0730              * I'm not going to try to support it, even though it
1278 0730              * works on ROM 1.
1279 0730              *
1280 0730              ********************************************************
1281 0730              SetFrameColor proc 
1282 0730                       import KillColorTable 
1283 0730
1284 0730 48                    pha   
1285 0731
1286 0731 A3 0B                 lda   11,s
1287 0733 48                    pha   
1288 0734 A3 0B                 lda   11,s
1289 0736 48                    pha   
1290 0737 20 3F 0A              jsr   KillColorTable
1291 073A
1292 073A 68                    pla   
1293 073B 5C E0 10 FD           jml   >$fd10e0                 ;original SetFrameColor in ROM
1294 073F
1295 073F                       EndP 
1296 073F
1297 073F              ********************************************************
1298 073F              *
1299 073F              * KillColorTable routine -- used by CloseWindow and
1300 073F              *                           SetFrameColor
1301 073F              *
1302 073F              * 21-May-91 DAL
1303 073F              *
1304 073F              * Input: window pointer on stack (removed on exit).
1305 073F              * Call by JSR.
1306 073F              *
1307 073F              * If the window is a *standard* window and it has a
1308 073F              * color table pointer with bit 30 set, then we must
1309 073F              * FindHandle/DisposeHandle it and set the field to 0.
1310 073F              *
1311 073F              ********************************************************
1312 073F              KillColorTable proc 
1313 073F
1314 073F 0B                    phd   
1315 0740 3B                    tsc   
1316 0741 5B                    tcd   
1317 0742
1318 0742              @wind    equ   5                        ;direct page
1319 0742
1320 0742 A5 06                 lda   <@wind+1
1321 0744 F0 39                 beq   @boring                  ;NIL
1322 0746
1323 0746 A0 AB 00              ldy   #$AA+1                   ;check middle word of defproc
1324 0749 B7 05                 lda   [<@wind],y
1325 074B C9 43 FD              cmp   #$fd43                   ;standard = $fd4352 on ROM 3
1326 074E D0 2F                 bne   @boring
1327 0750
1328 0750 A0 E2 00              ldy   #$E0+2
1329 0753 B7 05                 lda   [<@wind],y
1330 0755 0A                    asl   a
1331 0756 10 27                 bpl   @boring                  ;bit 30 was clear
1332 0758
1333 0758 48                    pha   
1334 0759 48                    pha                            ;space for FindHandle
1335 075A B7 05                 lda   [<@wind],y
1336 075C 29 FF 00              and   #$00ff
1337 075F 48                    pha   
1338 0760 88                    dey   
1339 0761 88                    dey   
1340 0762 B7 05                 lda   [<@wind],y
1341 0764 48                    pha   
1342 0765 A2 02 1A 22           _FindHandle 
1343 076C A2 02 10 22           _DisposeHandle 
1344 0773 A9 00 00              lda   #0
1345 0776 A0 E2 00              ldy   #$E0+2
1346 0779 97 05                 sta   [<@wind],y
1347 077B 88                    dey   
1348 077C 88                    dey   
1349 077D 97 05                 sta   [<@wind],y
1350 077F
1351 077F 2B           @boring  pld   
1352 0780
1353 0780 FA                    plx   
1354 0781 68                    pla   
1355 0782 68                    pla                            ;kill input window pointer
1356 0783 DA                    phx                            ;restore return address
1357 0784 60                    rts   
1358 0785
1359 0785                       EndP 
1360 0785
1361 0785
1362 0785                       EJECT 
1363 0785              *******************************************************************************
1364 0785              *
1365 0785              WMgrJsrGlue PROC 
1366 0785              *
1367 0785              * Description:      These glue routines will be used to call window manager routines
1368 0785              *                   that are in ROM and end in an rts. This can be used for making
1369 0785              *                   the patch files smaller.
1370 0785              *
1371 0785              *
1372 0785              * Inputs:           <A> Address of the routine to jump to in the window manager's
1373 0785              *                   bank.
1374 0785              *
1375 0785              * Outputs:          None
1376 0785              *
1377 0785              * External Refs:
1378 0785              *
1379 0785              * Entry Points:
1380 0785              *
1381 0785              *******************************************************************************
1382 0785
1383 0785              aWindowRTL equ   $FD0392                ; an RTL in the window manager bank
1384 0785              CallProcRtn equ   $FD11C9               ; call proc glue routine
1385 0785              Pop8Bytes equ   $FD8FC3                 ; pop 8 bytes from the stack
1386 0785
1387 0785                       Entry CallProcGlue 
1388 0785              CallProcGlue  
1389 0785 F4 91 03              pea   <aWindowRTL-1            ; push the low word of an RTL on the stack
1390 0788 5C C9 11 FD           jml   CallProcRtn              ; call the setup routine
1391 078C
1392 078C                       Entry Pop8BytesGlue 
1393 078C              Pop8BytesGlue  
1394 078C 5C C3 8F FD           jml   Pop8Bytes
1395 0790                       EndP 
1396 0790
1397 0790
1398 0790                       EJECT 
1399 0790              *******************************************************************************
1400 0790              *
1401 0790              Setup    PROC 
1402 0790              *
1403 0790              * Description:
1404 0790              *
1405 0790              *
1406 0790              * Inputs:           None
1407 0790              *
1408 0790              * Outputs:          None
1409 0790              *
1410 0790              * External Refs:
1411 0790              *
1412 0790              * Entry Points:
1413 0790              *
1414 0790              *******************************************************************************
1415 0790              ;
1416 0790              ;=======================================================
1417 0790              ;        Switch to Window Manager's zero page,
1418 0790              ;        and put input parameters into zero page.
1419 0790              ;=======================================================
1420 0790              ;
1421 0790              ;  IN:   a = zero page to switch to.
1422 0790              ;
1423 0790              ;
1424 0790 22 64 00 E1           jsl   IncBusyFlg
1425 0794
1426 0794 FA                    plx                            Get return address.
1427 0795 0B                    phd                            Save current zero page pointer.
1428 0796 DA                    phx                            Put return address back on stack.
1429 0797
1430 0797 5B                    tcd                            Switch to Window Manager's zero page.
1431 0798
1432 0798
1433 0798                       ENTRY pullparams 
1434 0798              pullparams  
1435 0798
1436 0798 A3 0F                 lda   15,s                     Pull second to last input parameter.
1437 079A 85 AE                 sta   <workptr
1438 079C A3 11                 lda   17,s
1439 079E 85 B0                 sta   <workptr+2
1440 07A0
1441 07A0                       ENTRY pullparam 
1442 07A0              pullparam  
1443 07A0
1444 07A0 A3 0D                 lda   13,s                     Pull last input parameter.
1445 07A2 AA                    tax   
1446 07A3 A3 0B                 lda   11,s
1447 07A5                       ENDP 
1448 07A5
1449 07A5
1450 07A5              ;============================================
1451 07A5              ;          Compute window pointer
1452 07A5              ;          from port pointer.
1453 07A5              ;============================================
1454 07A5              ;
1455 07A5              ;   IN:    a = low word of port pointer.
1456 07A5              ;          x = high word of port pointer.
1457 07A5              ;
1458 07A5              ;  OUT:    wind = window pointer.
1459 07A5              ;          a = low word of window pointer.
1460 07A5              ;          x = high word of window pointer.
1461 07A5              ;          y = trashed.
1462 07A5              ;
1463 07A5                       EXPORT get_wptr 
1464 07A5              get_wptr PROC 
1465 07A5
1466 07A5 A8                    tay   
1467 07A6 D0 03                 bne   ok1                      Null pointer?
1468 07A8 9B                    txy   
1469 07A9 F0 07                 beq   store1
1470 07AB
1471 07AB 38           ok1      sec   
1472 07AC E9 04 00              sbc   #wport                   Compute pointer to window record
1473 07AF B0 01                 bcs   store1                   from pointer to window's port.
1474 07B1 CA                    dex   
1475 07B2 85 A6        store1   sta   <wind
1476 07B4 86 A8                 stx   <wind+2
1477 07B6
1478 07B6 60                    rts   
1479 07B7                       ENDP 
1480 07B7
1481 07B7
1482 07B7                       EJECT 
1483 07B7              *******************************************************************************
1484 07B7              *
1485 07B7              NewStartup PROC 
1486 07B7              *
1487 07B7              * Description:      This routine will postpatch the window mgr startup call
1488 07B7              *                   so that the window globals area can be grown
1489 07B7              *
1490 07B7              *******************************************************************************
1491 07B7              ;WindStartup Stack
1492 07B7              OldDPage equ   1
1493 07B7              NewDataHandle equ   OldDPage+2
1494 07B7              RTL1     equ   NewDataHandle+4
1495 07B7              RTL2     equ   RTL1+3
1496 07B7              theID    equ   RTL2+3
1497 07B7
1498 07B7              pSize    equ   2
1499 07B7
1500 07B7              RomStartup equ   $FD018C                ; address of the old startup call
1501 07B7
1502 07B7 A9 00 00              lda   #0                       ;added 24-Sep-90 DAL
1503 07BA 8F 84 0D 02           sta   >WindowUpdateCount       ;added 24-Sep-90 DAL
1504 07BE
1505 07BE              *** added 16-Sep-91 DAL -- pre-locate the disk-swap icons
1506 07BE                       import DiskSwap640Hndl,DiskSwap320Hndl 
1507 07BE 48                    pha   
1508 07BF 48                    pha   
1509 07C0 F4 01 80              pea   $8001                    ;rIcon
1510 07C3 F4 FF 07              pea   $07ff
1511 07C6 F4 06 00              pea   $0006                    ;disk-swap 640
1512 07C9 A2 1E 0E 22           _LoadResource 
1513 07D0 68                    pla   
1514 07D1 8F E3 16 02           sta   >DiskSwap640Hndl
1515 07D5 68                    pla   
1516 07D6 8F E5 16 02           sta   >DiskSwap640Hndl+2
1517 07DA
1518 07DA 48                    pha   
1519 07DB 48                    pha   
1520 07DC F4 01 80              pea   $8001                    ;rIcon
1521 07DF F4 FF 07              pea   $07ff
1522 07E2 F4 06 01              pea   $0106                    ;disk-swap 320
1523 07E5 A2 1E 0E 22           _LoadResource 
1524 07EC 68                    pla   
1525 07ED 8F E7 16 02           sta   >DiskSwap320Hndl
1526 07F1 68                    pla   
1527 07F2 8F E9 16 02           sta   >DiskSwap320Hndl+2
1528 07F6              *** end 16-Sep-91
1529 07F6
1530 07F6              *** added 12-Apr-91 DAL -- initialize HandleDiskInsert
1531 07F6 48                    pha   
1532 07F7 48                    pha   
1533 07F8 F4 00 20              pea   $2000                    ;18-Apr-91 DAL -- init everything to current status
1534 07FB F4 00 00              pea   0
1535 07FE A2 0E 6B 22           _HandleDiskInsert 
1536 0805 68                    pla   
1537 0806 68                    pla   
1538 0807              *** end of 12-Apr-91 DAL
1539 0807
1540 0807              *** added 20-May-91 DAL -- try to load and start QDAux if it isn't already here
1541 0807 F4 00 00              pea   0
1542 080A A2 12 06 22           _QDAuxStatus 
1543 0811 68                    pla   
1544 0812 D0 14                 bne   @haveQDAux
1545 0814 F4 12 00              pea   $0012                    ;tool set = QDAux
1546 0817 F4 04 03              pea   $0304                    ;version = 3.4
1547 081A A2 01 0F 22           _LoadOneTool 
1548 0821 A2 12 02 22           _QDAuxStartUp 
1549 0828              @haveQDAux  
1550 0828              *** end of 20-May-91 DAL
1551 0828
1552 0828 48                    pha                            ; make room on the stack for new data handle
1553 0829 48                    pha   
1554 082A
1555 082A 0B                    phd                            ; save the users dpage
1556 082B 3B                    tsc   
1557 082C 5B                    tcd                            ; use the stack as a dpage
1558 082D
1559 082D 48                    pha                            ; space for result
1560 082E 48                    pha   
1561 082F F4 00 00 F4           PushLong #RAMSIZE 
1562 0835 D4 0D                 pei   theID
1563 0837 F4 10 40              pea   $4010                    ; Fixed, May not cross bank boundary
1564 083A 48                    pha                            ; Address doesn't matter
1565 083B 48                    pha   
1566 083C A2 02 09 22           _NewHandle 
1567 0843 90 05                 bcc   Ok
1568 0845
1569 0845 FA                    plx   
1570 0846 FA                    plx   
1571 0847 82 87 00              brl   Error
1572 084A
1573 084A 68           Ok       pla   
1574 084B 85 03                 sta   NewDataHandle
1575 084D 68                    pla   
1576 084E 85 05                 sta   NewDataHandle+2
1577 0850
1578 0850 A9 00 00              lda   #0
1579 0853 D4 0D                 pei   theID
1580 0855 22 E7 0B 02           jsl   StartupGlue
1581 0859 B0 76                 bcs   Error
1582 085B
1583 085B 48                    pha   
1584 085C A2 06 09 22           _DoWindows                     ; get our dpage 
1585 0863 2B                    pld   
1586 0864
1587 0864              ; Now push the handle to our data area on stack
1588 0864 48                    pha   
1589 0865 48                    pha   
1590 0866 D4 DA                 pei   <Data+2
1591 0868 D4 D8                 pei   <Data
1592 086A A2 02 1A 22           _FindHandle                    ; find handle to window mgr's data area
1593 0871 A3 03                 lda   3,s                      ; save extra copy of data handle so we can dispose
1594 0873 48                    pha                            ; of it after making a copy of the data in it
1595 0874 A3 03                 lda   3,s
1596 0876 48                    pha   
1597 0877 A3 0D                 lda   13,s                     ; get handle into which data will be copied into
1598 0879 85 DA                 sta   <Data+2                  ; get new handle into Data so we can use it to
1599 087B 48                    pha                            ; to deref in
1600 087C A3 0D                 lda   13,s
1601 087E 85 D8                 sta   <Data
1602 0880 48                    pha   
1603 0881              *** 17-Feb-92 DAL -- RAMSIZE is too big; only move the amount of data in the old handle.
1604 0881              ;;;	PushLong #RAMSIZE
1605 0881 F4 00 00              pea   0
1606 0884 F4 F2 01              pea   $01F2                    ;size of old data
1607 0887              *** end 17-Feb-92
1608 0887 A2 02 2A 22           _HandToHand 
1609 088E A2 02 10 22           _DisposeHandle                 ; get rid of old Data handle
1610 0895
1611 0895 A0 02 00              ldy   #2
1612 0898 B7 D8                 lda   [<Data],y                ; dereference new data area and update 
1613 089A AA                    tax                              ; window manager's data ptr
1614 089B A7 D8                 lda   [<Data]
1615 089D 85 D8                 sta   <Data
1616 089F 86 DA                 stx   <Data+2
1617 08A1              ;
1618 08A1              ; Now we must reinitialize some of the data in our new data segment because
1619 08A1              ; they are pointers to within this data segment.
1620 08A1              ; 
1621 08A1 A9 62 00              lda   #scInfo                  ; address to calculate
1622 08A4 A0 38 00              ldy   #scrn2scrn+PP_SrcInfo    ; where to store address
1623 08A7 20 EC 0B              jsr   GetAndStoreAddress
1624 08AA
1625 08AA A9 62 00              lda   #scInfo
1626 08AD A0 3C 00              ldy   #scrn2scrn+PP_DesInfo
1627 08B0 20 EC 0B              jsr   GetAndStoreAddress
1628 08B3
1629 08B3 A9 B0 01              lda   #blitsrc
1630 08B6 A0 40 00              ldy   #scrn2scrn+PP_SrcRect
1631 08B9 20 EC 0B              jsr   GetAndStoreAddress
1632 08BC
1633 08BC A9 B8 01              lda   #blitdes
1634 08BF A0 44 00              ldy   #scrn2scrn+PP_DesRect
1635 08C2 20 EC 0B              jsr   GetAndStoreAddress
1636 08C5
1637 08C5 A9 A4 01              lda   #fontHandle
1638 08C8 A0 0E 00              ldy   #windIconFont
1639 08CB 20 EC 0B              jsr   GetAndStoreAddress
1640 08CE
1641 08CE A9 00 00              lda   #0                       ; no error
1642 08D1
1643 08D1              ; Now that we are done, clean up and return
1644 08D1 AA           Error    tax                            ; save the error in <X>
1645 08D2 A3 0B                 lda   RTL1+4,s
1646 08D4 83 0D                 sta   RTL1+4+pSize,s
1647 08D6 A3 09                 lda   RTL1+2,s
1648 08D8 83 0B                 sta   RTL1+2+pSize,s
1649 08DA A3 07                 lda   RTL1,s
1650 08DC 83 09                 sta   RTL1+pSize,s
1651 08DE 2B                    pld                            ; recover the direct page
1652 08DF 68                    pla                            ; get rid of space for NewDataHandle
1653 08E0 68                    pla   
1654 08E1 68                    pla                            ; pull off our parameter
1655 08E2 8A                    txa   
1656 08E3 C9 01 00              cmp   #1                       ; set carry if error
1657 08E6 6B                    RTL   
1658 08E7
1659 08E7 22 8C 01 FD  StartupGlue jsl   ROMStartup            ; call the real startup routine
1660 08EB 6B                    rtl   
1661 08EC
1662 08EC
1663 08EC              ;----------------------------------------------------------------
1664 08EC              ;
1665 08EC              ;  IN: a-reg contains offset of address we want to calculate
1666 08EC              ;      y-reg contains offset of where to store address
1667 08EC              ;
1668 08EC              ; OUT: nothing
1669 08EC              ;
1670 08EC              ;----------------------------------------------------------------
1671 08EC              GetAndStoreAddress  
1672 08EC 18                    clc   
1673 08ED 65 D8                 adc   <Data
1674 08EF 97 D8                 sta   [<Data],y
1675 08F1 C8                    iny   
1676 08F2 C8                    iny   
1677 08F3 A5 DA                 lda   <Data+2
1678 08F5 97 D8                 sta   [<Data],y
1679 08F7
1680 08F7 60                    rts   
1681 08F8
1682 08F8                       EndP 
1683 08F8
1684 08F8
1685 08F8                       EJECT 
1686 08F8              *******************************************************************************
1687 08F8              *
1688 08F8              GetFrameColor PROC 
1689 08F8              *
1690 08F8              * Description:      Patched version of the ROM based getframe color routine
1691 08F8              *                   this routine must call many routines in the firmware, so
1692 08F8              *                   it must be patched in a special way. All jsr's have been 
1693 08F8              *                   replaced with JSL's to the proper routine
1694 08F8              *
1695 08F8              *
1696 08F8              * Inputs:           Pointer to color table
1697 08F8              *                   Pointer to window
1698 08F8              *
1699 08F8              * Outputs:          None
1700 08F8              *
1701 08F8              * External Refs:
1702 08F8              *
1703 08F8              * Entry Points:
1704 08F8              *
1705 08F8              *******************************************************************************
1706 08F8
1707 08F8              theWind  equ   9
1708 08F8              desTable equ   theWind+4
1709 08F8
1710 08F8 20 90 0A              jsr   setup
1711 08FB
1712 08FB A9 16 00              lda   #wGetColorTable          Ask defProc for color table pointer
1713 08FE 22 85 0A 02           jsl   callProcGlue
1714 0902 85 DE                 sta   <work                    Store pointer to color table.
1715 0904 86 E0                 stx   <work+2
1716 0906              ; Modified 5/10/89 Mensch
1717 0906              ; Add code here to detect if this is a handle or a pointer.
1718 0906 8A                    txa                            put high word into <A> to test for handle
1719 0907 10 0C                 bpl   @WorkOK                  High bit clear, work ok.
1720 0909 A0 02 00              ldy   #2                       else, dereference it in place.
1721 090C B7 DE                 lda   [<work],y
1722 090E AA                    tax   
1723 090F A7 DE                 lda   [<work]
1724 0911 85 DE                 sta   <work
1725 0913 86 E0                 stx   <work+2
1726 0915
1727 0915              @WorkOK   
1728 0915 A3 0D                 lda   desTable,s               Get pointer to destination table.
1729 0917 85 E2                 sta   <work+4
1730 0919 A3 0F                 lda   desTable+2,s
1731 091B 85 E4                 sta   <work+6
1732 091D
1733 091D A0 08 00              ldy   #8                       Clone color table into given table.
1734 0920 B7 DE        lop1     lda   [<work],y
1735 0922 97 E2                 sta   [<work+4],y
1736 0924 88                    dey   
1737 0925 88                    dey   
1738 0926 10 F8                 bpl   lop1
1739 0928
1740 0928 8B                    phb   
1741 0929 82 60 FE              brl   pop8bytesGlue
1742 092C                       ENDP 
1743 092C
1744 092C              ****************************************************************
1745 092C              *
1746 092C              * FindWindow patch (ROM 3) 25-Mar-91 DAL
1747 092C              *
1748 092C              * Pre-zero the <wind variable, so that if we return wInMenuBar
1749 092C              * we make sure to return NIL for the window pointer.  Besides
1750 092C              * being clean, this causes ModalDialog to beep if the user clicks
1751 092C              * in the menu bar.
1752 092C              *
1753 092C              ****************************************************************
1754 092C              FindWindow proc export 
1755 092C
1756 092C AA                    tax   
1757 092D A9 00 00              lda   #0
1758 0930 9F A6 00 00           sta   >$0000A6,x               ;zero out <wind
1759 0934 9F A8 00 00           sta   >$0000A8,x               ;zero out <wind+2
1760 0938 8A                    txa   
1761 0939 5C 56 19 FD           jml   >$fd1956                 ;original ROM 3 FindWindow
1762 093D
1763 093D                       EndP 
1764 093D
1765 093D              ****************************************************************
1766 093D              *
1767 093D              * GrowWindow patch (ROM 3) 26-Nov-90 DAL
1768 093D              *
1769 093D              * Patch around GrowWindow to preserve the old ZoomRect and
1770 093D              * frame bits (zoom state, at least) in the case that the
1771 093D              * window doesn't change size at all.
1772 093D              *
1773 093D              ****************************************************************
1774 093D              GrowWindow proc export 
1775 093D
1776 093D 8F FE 0C 02           sta   >oldAcc
1777 0941 68                    pla   
1778 0942 8F EA 0C 02           sta   >PrivateRTL
1779 0946 68                    pla   
1780 0947 8F EC 0C 02           sta   >PrivateRTL+2
1781 094B 68                    pla   
1782 094C 8F EE 0C 02           sta   >PrivateRTL+4
1783 0950
1784 0950 A3 03                 lda   3,s
1785 0952 8F F4 0C 02           sta   >gwTheWindow+2
1786 0956 AA                    tax   
1787 0957 A3 01                 lda   1,s
1788 0959 8F F2 0C 02           sta   >gwTheWindow
1789 095D
1790 095D 48                    pha                            ;space for GetWFrame
1791 095E DA                    phx   
1792 095F 48                    pha                            ;window pointer
1793 0960 A2 0E 2C 22           _GetWFrame 
1794 0967 68                    pla   
1795 0968 8F F0 0C 02           sta   >gwTheFrame
1796 096C
1797 096C 48                    pha   
1798 096D 48                    pha                            ;space for GetZoomRect
1799 096E AF F4 0C 02           lda   >gwTheWindow+2
1800 0972 48                    pha   
1801 0973 AF F2 0C 02           lda   >gwTheWindow
1802 0977 48                    pha   
1803 0978 A2 0E 37 22           _GetZoomRect 
1804 097F F4 02 00 F4           pushlong #oldZoomRect 
1805 0985 F4 00 00              pea   0
1806 0988 F4 08 00              pea   8
1807 098B A2 02 2B 22           _BlockMove 
1808 0992
1809 0992 AF FE 0C 02           lda   >oldAcc
1810 0996 22 E5 0C 02           jsl   ToROM
1811 099A B0 37                 bcs   @byebye
1812 099C A3 01                 lda   1,s
1813 099E 03 03                 ora   3,s
1814 09A0 D0 2D                 bne   @byeNoErr
1815 09A2
1816 09A2 F4 02 00 F4           pushlong #oldZoomRect 
1817 09A8 AF F4 0C 02           lda   >gwTheWindow+2
1818 09AC 48                    pha   
1819 09AD AF F2 0C 02           lda   >gwTheWindow
1820 09B1 48                    pha   
1821 09B2 A2 0E 38 22           _SetZoomRect 
1822 09B9
1823 09B9 AF F0 0C 02           lda   >gwTheFrame
1824 09BD 48                    pha   
1825 09BE AF F4 0C 02           lda   >gwTheWindow+2
1826 09C2 48                    pha   
1827 09C3 AF F2 0C 02           lda   >gwTheWindow
1828 09C7 48                    pha   
1829 09C8 A2 0E 2D 22           _SetWFrame 
1830 09CF
1831 09CF A9 00 00     @byeNoErr lda   #0
1832 09D2 18                    clc   
1833 09D3 AA           @byebye  tax   
1834 09D4 AF EE 0C 02           lda   >PrivateRTL+4
1835 09D8 48                    pha   
1836 09D9 AF EC 0C 02           lda   >PrivateRTL+2
1837 09DD 48                    pha   
1838 09DE AF EA 0C 02           lda   >PrivateRTL
1839 09E2 48                    pha   
1840 09E3 8A                    txa   
1841 09E4 6B                    rtl   
1842 09E5
1843 09E5 22 00 18 FD  ToROM    jsl   $fd1800
1844 09E9 6B                    rtl   
1845 09EA
1846 09EA 00 00 00 00  PrivateRTL DS B:6
1847 09F0 00 00        gwTheFrame DC W:0
1848 09F2 00 00 00 00  gwTheWindow DC L:0
1849 09F6 00 00 00 00  oldZoomRect DS B:8
1850 09FE 00 00        oldAcc   DC W:0
1851 0A00
1852 0A00                       EndP 
1853 0A00
1854 0A00                       title 'TaskMaster' 
1855 0A00              ****************************************************************
1856 0A00              *
1857 0A00              NewTaskMaster PROC 
1858 0A00              *
1859 0A00              * 9/7/89            Mensch
1860 0A00              * Add tmNoGetNextEvent bit.
1861 0A00              *
1862 0A00              ****************************************************************
1863 0A00                       DefineStack 
1864 0A00              WindMgrD word 
1865 0A00              ThisAction word 
1866 0A00              TheTaskMask LONG 
1867 0A00              WindPtr  LONG 
1868 0A00              DataPtr  LONG 
1869 0A00              CallingFlag WORD 
1870 0A00              OrigB    BYTE 
1871 0A00              OrigD    word 
1872 0A00              RTL1     block 3 
1873 0A00              RTL2     block 3 
1874 0A00              InputTaskRecPtr LONG 
1875 0A00              InputEventMask WORD 
1876 0A00              OutputTaskCode WORD 
1877 0A00
1878 0A00
1879 0A00 0B                    phd                            Save d-page and dbr on stack
1880 0A01 8B                    phb   
1881 0A02 5B                    tcd                            Switch in wmgr's dPage for a momment
1882 0A03
1883 0A03 F4 00 00              pea   $0000                    Push CallingFlag of zero to indicate call origin
1884 0A06
1885 0A06 D4 DA                 pei   <Data+2                  Push pointer to window mgr's globals
1886 0A08 D4 D8                 pei   <Data
1887 0A0A
1888 0A0A 48                    pha                            Push space for Window Pointer
1889 0A0B 48                    pha   
1890 0A0C
1891 0A0C 48                    pha                            Push space for the task mask
1892 0A0D 48                    pha   
1893 0A0E
1894 0A0E F4 00 00              pea   $0000                    ThisAction starts as zero
1895 0A11
1896 0A11 0B                    phd                            Push window manager's direct page!
1897 0A12
1898 0A12 3B                    tsc                            Turn our stack into direct page
1899 0A13 5B                    tcd   
1900 0A14
1901 0A14
1902 0A14 48                    pha                            Save the Port on the stack
1903 0A15 48                    pha   
1904 0A16 A2 04 1C 22           _GetPort 
1905 0A1D
1906 0A1D 24 11                 bit   CallingFlag
1907 0A1F 10 04                 bpl   DoNormalStuff
1908 0A21 D4 11                 pei   CallingFlag              ; push a non-zero value so it looks like there was an event.
1909 0A23 80 24                 bra   SkipNormalStuff
1910 0A25              DoNormalStuff  
1911 0A25              ;
1912 0A25              ; Call System Task now and get it over with
1913 0A25              ;
1914 0A25              ; 8/24/89 Mensch
1915 0A25              ; Added code here to skip getNextEvent in the case where the tmNoGetNextEvent bit is set in the
1916 0A25              ; task mask.
1917 0A25
1918 0A25 A0 16 00              ldy   #taskMask+2              ; get high word of the task mask
1919 0A28 B7 1C                 lda   [InputTaskRecPtr],y
1920 0A2A 29 20 00              and   #tmNoGetNextEvent
1921 0A2D F0 05                 beq   @getEvent                ; if zero, get an event here
1922 0A2F              ;
1923 0A2F              ; If we get this far, then no call to get next event should be made,
1924 0A2F              ; what we will do instead is get the taskwhat field and push it on the stack as the result of 
1925 0A2F              ; getnextevent, so that we can proceed
1926 0A2F              ;
1927 0A2F A7 1C                 lda   [InputTaskRecPtr]        ; event what is first field
1928 0A31 48                    pha   
1929 0A32 80 15                 bra   SkipNormalStuff            ; and continue with the rest of the call...
1930 0A34
1931 0A34              @getEvent  
1932 0A34
1933 0A34 A2 05 19 22           _SystemTask                    ;Call Desk Manager so it can pass a tick
1934 0A3B
1935 0A3B 48                    pha   
1936 0A3C D4 20                 pei   InputEventMask
1937 0A3E D4 1E                 pei   InputTaskRecPtr+2
1938 0A40 D4 1C                 pei   InputTaskRecPtr
1939 0A42 A2 06 0A 22           _GetNextEvent 
1940 0A49
1941 0A49              ;;;; Now get back into the ROM with this here call!
1942 0A49              ;;;
1943 0A49              ;;;SkipNormalStuff	jml	SkipNormalStuffROM
1944 0A49              *** added 1-Dec-92 DAL -- make tmNoGetNextEvent work!
1945 0A49              SkipNormalStuff  
1946 0A49 22 64 00 E1           jsl   IncBusyFlg               inc flag so that shared resources are in danger
1947 0A4D
1948 0A4D              ;
1949 0A4D              ; Put d-page and dbr in global data for use by w-def Procs.
1950 0A4D              ; 13 Apr 89 SEG
1951 0A4D A0 34 00              ldy   #callerDPage
1952 0A50 A5 14                 lda   OrigD
1953 0A52 97 0D                 sta   [<dataPtr],y
1954 0A54 A0 36 00              ldy   #callerDataB             high byte must be valid
1955 0A57 A5 12                 lda   OrigB-1
1956 0A59 97 0D                 sta   [<DataPtr],y
1957 0A5B              ; End Change
1958 0A5B
1959 0A5B A7 1C                 lda   [<InputTaskRecPtr]       Check this so we don't zero important data
1960 0A5D C9 13 00              cmp   #wInContent              for TaskMasterDA case
1961 0A60 F0 14                 beq   SkipThisShit
1962 0A62
1963 0A62 A0 02 00              ldy   #message                 Clone message into TaskData just in case.
1964 0A65 B7 1C                 lda   [<InputTaskRecPtr],y
1965 0A67 AA                    tax   
1966 0A68 C8                    iny   
1967 0A69 C8                    iny   
1968 0A6A B7 1C                 lda   [<InputTaskRecPtr],y
1969 0A6C A0 12 00              ldy   #TaskData+2
1970 0A6F 97 1C                 sta   [<InputTaskRecPtr],y
1971 0A71 88                    dey   
1972 0A72 88                    dey   
1973 0A73 8A                    txa   
1974 0A74 97 1C                 sta   [<InputTaskRecPtr],y
1975 0A76
1976 0A76              SkipThisShit  
1977 0A76 A0 16 00              ldy   #TaskMask+2              Get TaskMask into a zero page location.
1978 0A79 B7 1C                 lda   [<InputTaskRecPtr],y
1979 0A7B 85 07                 sta   TheTaskMask+2
1980 0A7D 29 80 FF              and   #$FF80                   Bits 23-31 must be clear.
1981 0A80
1982 0A80 5C F5 26 FD           jmp   $fd26f5                  ;"beq mask_ok" in ROM 3
1983 0A84              *** end 1-Dec-92
1984 0A84                       EndP 
1985 0A84
1986 0A84              *
1987 0A84              * WindowUpdateCount--used by BeginUpdate, EndUpdate, WindStatus, WindStartUp
1988 0A84              *
1989 0A84              * 24-Sep-90 DAL
1990 0A84              *
1991 0A84              WindowUpdateCount proc export 
1992 0A84 00 00                 DC W:0
1993 0A86                       EndP 
1994 0A86
1995 0A86
1996 0A86              ********************************************************
1997 0A86              *
1998 0A86              * WindStatus patch
1999 0A86              *
2000 0A86              * 24-Sep-90 DAL (new patch)
2001 0A86              *
2002 0A86              * Now returns with the carry set if there are any windows
2003 0A86              * being updated.
2004 0A86              *
2005 0A86              ********************************************************
2006 0A86              WindStatus PROC 
2007 0A86
2008 0A86 83 07                 sta   7,s                      Return status
2009 0A88
2010 0A88 AF 84 0D 02           lda   >WindowUpdateCount
2011 0A8C C9 01 00              cmp   #1
2012 0A8F
2013 0A8F A9 00 00              lda   #0
2014 0A92 6B                    rtl   
2015 0A93
2016 0A93              ********************************************************
2017 0A93              *
2018 0A93              * BeginUpdate patch
2019 0A93              *
2020 0A93              * 24-Sep-90 DAL (new patch)
2021 0A93              *
2022 0A93              * Increments WindowUpdateCount and jumps back into ROM.
2023 0A93              *
2024 0A93              ********************************************************
2025 0A93              BeginUpdate PROC 
2026 0A93
2027 0A93 AA                    tax   
2028 0A94 AF 84 0D 02           lda   >WindowUpdateCount
2029 0A98 1A                    inc   a
2030 0A99 8F 84 0D 02           sta   >WindowUpdateCount
2031 0A9D 8A                    txa   
2032 0A9E 5C 20 06 FD           jml   $fd0620
2033 0AA2
2034 0AA2                       EndP 
2035 0AA2
2036 0AA2              ********************************************************
2037 0AA2              *
2038 0AA2              * EndUpdate patch
2039 0AA2              *
2040 0AA2              * 24-Sep-90 DAL (new patch)
2041 0AA2              *
2042 0AA2              * Decrements WindowUpdateCount and jumps back into ROM.
2043 0AA2              *
2044 0AA2              ********************************************************
2045 0AA2              EndUpdate PROC 
2046 0AA2
2047 0AA2 AA                    tax   
2048 0AA3 AF 84 0D 02           lda   >WindowUpdateCount
2049 0AA7 3A                    dec   a
2050 0AA8 8F 84 0D 02           sta   >WindowUpdateCount
2051 0AAC 8A                    txa   
2052 0AAD 5C 69 06 FD           jml   $fd0669
2053 0AB1
2054 0AB1                       EndP 
2055 0AB1
2056 0AB1
2057 0AB1              ********************************************************
2058 0AB1              *
2059 0AB1              * GetWKind2 patch
2060 0AB1              *
2061 0AB1              * 15-May-91 DAL (new patch)
2062 0AB1              *
2063 0AB1              * Checks for the NIL case and then jumps back to ROM.
2064 0AB1              *
2065 0AB1              ********************************************************
2066 0AB1              GetWKind2 proc 
2067 0AB1
2068 0AB1 48                    pha   
2069 0AB2 A3 0A                 lda   7+1+2,s
2070 0AB4 D0 0D                 bne   @notNIL
2071 0AB6 83 0D                 sta   11+2,s                   ;zero out result word
2072 0AB8 68                    pla   
2073 0AB9 A2 00 00              ldx   #0                       ;no error
2074 0ABC A0 04 00              ldy   #4                       ;pop 4 bytes
2075 0ABF 5C 84 01 E1           jml   $e10184                  ;ToStrip
2076 0AC3
2077 0AC3 68           @notNIL  pla   
2078 0AC4 5C 42 10 FD           jml   >$fd1042
2079 0AC8
2080 0AC8                       EndP 
2081 0AC8
2082 0AC8
2083 0AC8                       END   
